/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.Arrays;
import java.util.List;
import org.kie.pmml.api.exceptions.KieEnumException;

public enum OPERATOR {
    EQUAL("equal", "=="),
    NOT_EQUAL("notEqual", "!="),
    LESS_THAN("lessThan", "<"),
    LESS_OR_EQUAL("lessOrEqual", "<="),
    GREATER_THAN("greaterThan", ">"),
    GREATER_OR_EQUAL("greaterOrEqual", ">="),
    IS_MISSING("isMissing", ""),
    IS_NOT_MISSING("isNotMissing", "");

    static final List<OPERATOR> NUMBER_OPERATORS;
    static final List<OPERATOR> ONLY_NUMBER_OPERATORS;
    static final List<OPERATOR> VALUE_OPERATORS;
    private final String name;
    private final String operator;

    private OPERATOR(String name, String operator) {
        this.name = name;
        this.operator = operator;
    }

    public static OPERATOR byName(String name) {
        return Arrays.stream(OPERATOR.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find OPERATOR with name: " + name));
    }

    public boolean isOnlyNumberOperator() {
        return ONLY_NUMBER_OPERATORS.contains((Object)this);
    }

    public boolean isValueOperator() {
        return VALUE_OPERATORS.contains((Object)this);
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        return this.operator;
    }

    static {
        NUMBER_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, LESS_THAN, LESS_OR_EQUAL, GREATER_THAN, GREATER_OR_EQUAL);
        ONLY_NUMBER_OPERATORS = Arrays.asList(LESS_THAN, LESS_OR_EQUAL, GREATER_THAN, GREATER_OR_EQUAL);
        VALUE_OPERATORS = Arrays.asList(EQUAL, NOT_EQUAL, LESS_THAN, LESS_OR_EQUAL, GREATER_THAN, GREATER_OR_EQUAL);
    }
}

