/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.utils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.kie.pmml.api.enums.PMML_MODEL;

public class SourceUtils {
    public static final String DUMP_KIE_PMML_SOURCES = "dumpKiePmmlSources";
    public static final String DUMP_KIE_PMML_DIRECTORY = "dumpKiePmmlDirectory";
    public static final String DEFAULT_DUMP_KIE_PMML_DIRECTORY = "generated-pmml-sources";

    private SourceUtils() {
    }

    public static void dumpSources(Map<String, String> classNameSourceMap, PMML_MODEL pmmlModel) throws IOException {
        String dumpKiePmmlSources = System.getProperty(DUMP_KIE_PMML_SOURCES);
        if ("true".equalsIgnoreCase(dumpKiePmmlSources)) {
            String outputDir = System.getProperty(DUMP_KIE_PMML_DIRECTORY, DEFAULT_DUMP_KIE_PMML_DIRECTORY);
            String targetPath = String.format("%1$s%2$starget%2$s%3$s", System.getProperty("user.dir"), File.separator, outputDir);
            File targetDirectory = new File(targetPath);
            if (!targetDirectory.exists()) {
                Files.createDirectories(targetDirectory.toPath().getParent(), new FileAttribute[0]);
            }
            SourceUtils.dumpGeneratedSources(targetDirectory, classNameSourceMap, pmmlModel.getName().toLowerCase());
        }
    }

    private static void dumpGeneratedSources(File targetDirectory, Map<String, String> classNameSourceMap, String dumpKieSourcesFolder) {
        for (Map.Entry<String, String> entry : classNameSourceMap.entrySet()) {
            Path sourceDestinationPath = Paths.get(targetDirectory.getPath(), dumpKieSourcesFolder, entry.getKey().replace('.', '/') + ".java");
            SourceUtils.writeFile(sourceDestinationPath, entry.getValue().getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void writeFile(Path packagesDestinationPath, byte[] value) {
        try {
            if (!packagesDestinationPath.toFile().exists()) {
                Files.createDirectories(packagesDestinationPath.getParent(), new FileAttribute[0]);
            }
            Files.write(packagesDestinationPath, value, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

