/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.utils.ConverterTypeUtil;

public class ConverterTypeUtilTest {
    private static Map<String, Object> CONVERTIBLE_FROM_STRING = new HashMap<String, Object>();
    private static Map<String, Object> UNCONVERTIBLE_FROM_STRING;
    private static Map<Object, String> CONVERTIBLE_TO_STRING;

    @Test
    public void convertConvertibleToString() {
        CONVERTIBLE_TO_STRING.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            Object retrieved = ConverterTypeUtil.convert(expectedClass, (Object)s);
            Assert.assertEquals((Object)retrieved, (Object)o);
        });
    }

    @Test
    public void convertConvertibleFromString() {
        CONVERTIBLE_FROM_STRING.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            Object retrieved = ConverterTypeUtil.convert(expectedClass, (Object)s);
            Assert.assertEquals((Object)retrieved, (Object)o);
        });
    }

    @Test
    public void convertUnconvertible() {
        UNCONVERTIBLE_FROM_STRING.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            try {
                ConverterTypeUtil.convert(expectedClass, (Object)s);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s %s", s, o));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        });
    }

    static {
        CONVERTIBLE_FROM_STRING.put("true", true);
        CONVERTIBLE_FROM_STRING.put("false", false);
        CONVERTIBLE_FROM_STRING.put("23423", 23423);
        CONVERTIBLE_FROM_STRING.put("3476345444745745746", 3476345444745745746L);
        CONVERTIBLE_FROM_STRING.put("234.23", 234.23);
        CONVERTIBLE_FROM_STRING.put("234234.23", Float.valueOf(234234.23f));
        CONVERTIBLE_FROM_STRING.put("A", Character.valueOf('A'));
        CONVERTIBLE_FROM_STRING.put("2", (byte)2);
        CONVERTIBLE_FROM_STRING.put("234", (short)234);
        UNCONVERTIBLE_FROM_STRING = new HashMap<String, Object>();
        UNCONVERTIBLE_FROM_STRING.put("true", 23423);
        UNCONVERTIBLE_FROM_STRING.put("false", 3476345444745745746L);
        UNCONVERTIBLE_FROM_STRING.put("23423", true);
        UNCONVERTIBLE_FROM_STRING.put("3476345444745745746", (byte)2);
        UNCONVERTIBLE_FROM_STRING.put("234.23", 3476345444745745746L);
        UNCONVERTIBLE_FROM_STRING.put("234234.23", (short)234);
        UNCONVERTIBLE_FROM_STRING.put("A", (byte)2);
        UNCONVERTIBLE_FROM_STRING.put("Arwtrwetwe", Character.valueOf('A'));
        CONVERTIBLE_TO_STRING = new HashMap<Object, String>();
        CONVERTIBLE_TO_STRING.put(true, "true");
        CONVERTIBLE_TO_STRING.put(false, "false");
        CONVERTIBLE_TO_STRING.put(23423, "23423");
        CONVERTIBLE_TO_STRING.put(3476345444745745746L, "3476345444745745746");
        CONVERTIBLE_TO_STRING.put(234.23, "234.23");
        CONVERTIBLE_TO_STRING.put(Float.valueOf(234234.23f), "234234.23");
        CONVERTIBLE_TO_STRING.put(Character.valueOf('A'), "A");
        CONVERTIBLE_TO_STRING.put((byte)2, "2");
        CONVERTIBLE_TO_STRING.put((short)234, "234");
    }
}

