/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSimplePredicate
extends KiePMMLPredicate {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLSimplePredicate.class);
    private final OPERATOR operator;
    protected Object value;

    protected KiePMMLSimplePredicate(String name, List<KiePMMLExtension> extensions, OPERATOR operator) {
        super(name, extensions);
        this.operator = operator;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, OPERATOR operator) {
        return new Builder(name, extensions, operator);
    }

    @Override
    public boolean evaluate(Map<String, Object> values) {
        boolean toReturn = false;
        if (values.containsKey(this.name)) {
            logger.debug("found matching parameter, evaluating... ");
            toReturn = this.evaluation(values.get(this.name));
        }
        return toReturn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OPERATOR getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "KiePMMLSimplePredicate{operator=" + this.operator + ", name='" + this.name + '\'' + ", value=" + this.value + ", extensions=" + this.extensions + ", id='" + this.id + '\'' + ", parentId='" + this.parentId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLSimplePredicate that = (KiePMMLSimplePredicate)o;
        return this.operator == that.operator && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operator, this.name, this.value);
    }

    protected boolean evaluation(Object inputValue) {
        switch (this.operator) {
            case EQUAL: {
                return this.value.equals(inputValue);
            }
            case NOT_EQUAL: {
                return !this.value.equals(inputValue);
            }
            case LESS_THAN: {
                if (inputValue instanceof Number && this.value instanceof Number) {
                    return ((Number)inputValue).doubleValue() < ((Number)this.value).doubleValue();
                }
                return false;
            }
            case LESS_OR_EQUAL: {
                if (inputValue instanceof Number && this.value instanceof Number) {
                    return ((Number)inputValue).doubleValue() <= ((Number)this.value).doubleValue();
                }
                return false;
            }
            case GREATER_THAN: {
                if (inputValue instanceof Number && this.value instanceof Number) {
                    return ((Number)inputValue).doubleValue() > ((Number)this.value).doubleValue();
                }
                return false;
            }
            case GREATER_OR_EQUAL: {
                if (inputValue instanceof Number && this.value instanceof Number) {
                    return ((Number)inputValue).doubleValue() >= ((Number)this.value).doubleValue();
                }
                return false;
            }
            case IS_MISSING: 
            case IS_NOT_MISSING: {
                throw new IllegalArgumentException(BOOLEAN_OPERATOR.SURROGATE + " not supported, yet");
            }
        }
        throw new KiePMMLException("Unknown OPERATOR " + this.operator);
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLSimplePredicate> {
        private Builder(String name, List<KiePMMLExtension> extensions, OPERATOR operator) {
            super("SimplePredicate-", () -> new KiePMMLSimplePredicate(name, extensions, operator));
        }

        public Builder withValue(Object value) {
            ((KiePMMLSimplePredicate)this.toBuild).value = value;
            return this;
        }
    }
}

