/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;

public class KiePMMLCompoundPredicateTest {
    private final String COMPOUND_PREDICATE_NAME = "COMPOUNDPREDICATENAME";
    private final String SIMPLE_SET_PREDICATE_STRING_NAME = "SIMPLESETPREDICATESTRINGNAME";
    private final String SIMPLE_SET_PREDICATE_INT_NAME = "SIMPLESETPREDICATEINTNAME";

    @Test
    public void evaluateCompoundPredicateSinglePredicate() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.AND, Collections.singletonList(kiePMMLSimpleSetPredicateString));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        Assert.assertFalse((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        Assert.assertTrue((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.AND, Collections.singletonList(kiePMMLSimpleSetPredicateInt));
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assert.assertFalse((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assert.assertTrue((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateCompoundPredicateAnd() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.AND, Arrays.asList(kiePMMLSimpleSetPredicateString, kiePMMLSimpleSetPredicateInt));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assert.assertFalse((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assert.assertFalse((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assert.assertTrue((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
    }

    @Test
    public void evaluateCompoundPredicateOr() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.OR, Arrays.asList(kiePMMLSimpleSetPredicateString, kiePMMLSimpleSetPredicateInt));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assert.assertFalse((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assert.assertTrue((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assert.assertTrue((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assert.assertTrue((boolean)kiePMMLCompoundPredicate.evaluate(inputData));
    }

    @Test(expected=IllegalArgumentException.class)
    public void evaluateCompoundPredicateSurrogate() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.SURROGATE, Arrays.asList(kiePMMLSimpleSetPredicateString, kiePMMLSimpleSetPredicateInt));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        kiePMMLCompoundPredicate.evaluate(inputData);
    }

    private KiePMMLCompoundPredicate getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR booleanOperator, List<KiePMMLPredicate> kiePMMLPredicates) {
        return (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)booleanOperator).withKiePMMLPredicates(kiePMMLPredicates).build();
    }

    private KiePMMLSimpleSetPredicate getKiePMMLSimpleSetPredicate(String predicateName, List<Object> values, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
        return (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)predicateName, Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
    }

    private List<Object> getObjects(ARRAY_TYPE arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return Integer.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return Double.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return UUID.randomUUID().toString();
                }
            }
            return null;
        }).collect(Collectors.toList());
    }
}

