/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.commons.model.KiePMMLTarget;

public class KiePMMLTargetTest {
    private static final String TARGET_NAME = "TARGET_NAME";

    @Test
    public void modifyPrediction() {
        Object object = "STRING";
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder().build();
        Assert.assertEquals((Object)object, (Object)kiePMMLTarget.modifyPrediction(object));
        object = 4.33;
        Assert.assertEquals((Object)object, (Object)kiePMMLTarget.modifyPrediction(object));
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder().withMin(4.34).build();
        object = "STRING";
        Assert.assertEquals((Object)object, (Object)kiePMMLTarget.modifyPrediction(object));
        object = 4.33;
        Assert.assertEquals((Object)4.34, (Object)kiePMMLTarget.modifyPrediction(object));
    }

    @Test
    public void applyMin() {
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder().build();
        Assert.assertEquals((double)4.33, (double)kiePMMLTarget.applyMin(4.33), (double)0.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder().withMin(4.34).build();
        Assert.assertEquals((double)4.34, (double)kiePMMLTarget.applyMin(4.33), (double)0.0);
        Assert.assertEquals((double)4.35, (double)kiePMMLTarget.applyMin(4.35), (double)0.0);
    }

    @Test
    public void applyMax() {
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder().build();
        Assert.assertEquals((double)4.33, (double)kiePMMLTarget.applyMax(4.33), (double)0.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder().withMax(4.34).build();
        Assert.assertEquals((double)4.33, (double)kiePMMLTarget.applyMax(4.33), (double)0.0);
        Assert.assertEquals((double)4.34, (double)kiePMMLTarget.applyMax(4.35), (double)0.0);
    }

    @Test
    public void applyRescaleFactor() {
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder().build();
        Assert.assertEquals((double)4.0, (double)kiePMMLTarget.applyRescaleFactor(4.0), (double)0.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder().withRescaleFactor(2.0).build();
        Assert.assertEquals((double)8.0, (double)kiePMMLTarget.applyRescaleFactor(4.0), (double)0.0);
    }

    @Test
    public void applyRescaleConstant() {
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder().build();
        Assert.assertEquals((double)6.0, (double)kiePMMLTarget.applyRescaleConstant(6.0), (double)0.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder().withRescaleConstant(2.0).build();
        Assert.assertEquals((double)8.0, (double)kiePMMLTarget.applyRescaleConstant(6.0), (double)0.0);
    }

    @Test
    public void applyCastInteger() {
        KiePMMLTarget kiePMMLTarget = (KiePMMLTarget)this.getBuilder().build();
        Assert.assertEquals((double)2.718, (double)((Double)kiePMMLTarget.applyCastInteger(2.718)), (double)0.0);
        kiePMMLTarget = (KiePMMLTarget)this.getBuilder().withCastInteger(CAST_INTEGER.ROUND).build();
        Assert.assertEquals((double)3.0, (double)((Double)kiePMMLTarget.applyCastInteger(2.718)), (double)0.0);
    }

    private KiePMMLTarget.Builder getBuilder() {
        return KiePMMLTarget.builder((String)TARGET_NAME, Collections.emptyList());
    }
}

