/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class KiePMMLApplyTest {
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String OUTER_FUNCTION = "OUTER_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;
    private static final Object expected = value1 / value2;

    @Test(expected=IllegalArgumentException.class)
    public void evaluateUnknownFunction() {
        String name = "name";
        String function = "UNKNOWN";
        String defaultValue = null;
        String mapMissingTo = null;
        String invalidTreatmentValue = null;
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value1);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value2);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)name, Collections.emptyList(), (String)function).withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).withDefaultValue(defaultValue).withMapMissingTo(mapMissingTo).withInvalidValueTreatmentMethod(invalidTreatmentValue).build();
        kiePMMLApply.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void evaluateFromBuiltIn() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value1);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value2);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        Object retrieved = kiePMMLApply.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(FIELD_NAME, Collections.emptyList(), null);
        kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLFieldRef)).build();
        List<KiePMMLNameValue> kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue(FIELD_NAME, (Object)value2));
        retrieved = kiePMMLApply.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), kiePMMLNameValues);
        Assert.assertEquals((Object)expected, (Object)retrieved);
        KiePMMLDerivedField kiePMMLDerivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)FIELD_NAME, Collections.emptyList(), (String)DATA_TYPE.DOUBLE.getName(), (String)OP_TYPE.CONTINUOUS.getName(), (KiePMMLExpression)kiePMMLConstant2).build();
        List<KiePMMLDerivedField> derivedFields = Collections.singletonList(kiePMMLDerivedField);
        kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue("UNKNOWN", (Object)"WRONG"));
        retrieved = kiePMMLApply.evaluate(Collections.emptyList(), derivedFields, Collections.emptyList(), kiePMMLNameValues);
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    @Test
    public void evaluateFromDefineFunction() {
        Double valueA = 33.0;
        Double valueB = 27.0;
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)valueA);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)valueB);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)CUSTOM_FUNCTION).withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        List<KiePMMLDefineFunction> defineFunctions = Collections.singletonList(this.getDefineFunctionApplyFromConstant());
        Object retrieved = kiePMMLApply.evaluate(defineFunctions, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((Object)expected, (Object)retrieved);
        defineFunctions = Collections.singletonList(this.getDefineFunctionApplyFromFieldRef());
        retrieved = kiePMMLApply.evaluate(defineFunctions, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Double locallyExpected = value1 / valueB;
        Assert.assertEquals((Object)locallyExpected, (Object)retrieved);
        kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)OUTER_FUNCTION).withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        defineFunctions = Arrays.asList(this.getDefineFunctionApplyFromFieldRef(), this.getDefineFunctionApplyFromCustomFunction());
        retrieved = kiePMMLApply.evaluate(defineFunctions, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((Object)locallyExpected, (Object)retrieved);
    }

    private KiePMMLDefineFunction getDefineFunctionApplyFromConstant() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant(PARAM_2, Collections.emptyList(), (Object)value2);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        return new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
    }

    private KiePMMLDefineFunction getDefineFunctionApplyFromFieldRef() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1);
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLFieldRef)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        return new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
    }

    private KiePMMLDefineFunction getDefineFunctionApplyFromCustomFunction() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)CUSTOM_FUNCTION).withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        return new KiePMMLDefineFunction(OUTER_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
    }
}

