/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class KiePMMLFieldRef
extends AbstractKiePMMLComponent
implements KiePMMLExpression {
    private static final long serialVersionUID = 4576394527423997787L;
    private String mapMissingTo;

    public KiePMMLFieldRef(String name, List<KiePMMLExtension> extensions, String mapMissingTo) {
        super(name, extensions);
        this.mapMissingTo = mapMissingTo;
    }

    public String getMapMissingTo() {
        return this.mapMissingTo;
    }

    @Override
    public Object evaluate(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return Stream.of(this.getFromKiePMMLNameValues(kiePMMLNameValues), this.getFromDerivedFields(defineFunctions, derivedFields, outputFields, kiePMMLNameValues), this.getFromOutputFields(defineFunctions, derivedFields, outputFields, kiePMMLNameValues)).filter(Optional::isPresent).findFirst().map(Optional::get).orElse(this.mapMissingTo);
    }

    public String toString() {
        return "KiePMMLFieldRef{mapMissingTo='" + this.mapMissingTo + '\'' + ", extensions=" + this.extensions + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLFieldRef that = (KiePMMLFieldRef)o;
        return Objects.equals(this.mapMissingTo, that.mapMissingTo);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mapMissingTo);
    }

    private Optional<Object> getFromKiePMMLNameValues(List<KiePMMLNameValue> kiePMMLNameValues) {
        return kiePMMLNameValues.stream().filter(kiePMMLNameValue -> kiePMMLNameValue.getName().equals(this.name)).findFirst().map(KiePMMLNameValue::getValue);
    }

    private Optional<Object> getFromDerivedFields(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return derivedFields.stream().filter(derivedField -> derivedField.getName().equals(this.name)).findFirst().map(derivedField -> derivedField.evaluate(defineFunctions, derivedFields, outputFields, kiePMMLNameValues));
    }

    private Optional<Object> getFromOutputFields(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return outputFields.stream().filter(outputField -> outputField.getName().equals(this.name)).findFirst().map(outputField -> outputField.evaluate(defineFunctions, derivedFields, outputFields, kiePMMLNameValues));
    }
}

