/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;

public abstract class KiePMMLModel
extends AbstractKiePMMLComponent
implements PMMLModel {
    private static final long serialVersionUID = 759750766311061701L;
    protected PMML_MODEL pmmlMODEL;
    protected MINING_FUNCTION miningFunction;
    protected String targetField;
    protected Map<String, Object> outputFieldsMap = new HashMap<String, Object>();
    protected List<MiningField> miningFields = new ArrayList<MiningField>();
    protected List<OutputField> outputFields = new ArrayList<OutputField>();
    protected List<KiePMMLOutputField> kiePMMLOutputFields = new ArrayList<KiePMMLOutputField>();
    protected List<KiePMMLTarget> kiePMMLTargets = new ArrayList<KiePMMLTarget>();
    protected KiePMMLTransformationDictionary transformationDictionary;
    protected KiePMMLLocalTransformations localTransformations;
    protected Object predictedDisplayValue;
    protected Object entityId;
    protected Object affinity;

    protected KiePMMLModel(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public PMML_MODEL getPmmlMODEL() {
        return this.pmmlMODEL;
    }

    public MINING_FUNCTION getMiningFunction() {
        return this.miningFunction;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public Map<String, Object> getOutputFieldsMap() {
        return Collections.unmodifiableMap(this.outputFieldsMap);
    }

    public String getKModulePackageName() {
        String className = this.getClass().getCanonicalName();
        return className.substring(0, className.lastIndexOf(46));
    }

    public List<MiningField> getMiningFields() {
        return this.miningFields;
    }

    public void setMiningFields(List<MiningField> miningFields) {
        this.miningFields = Collections.unmodifiableList(miningFields);
    }

    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<OutputField> outputFields) {
        this.outputFields = Collections.unmodifiableList(outputFields);
    }

    public List<KiePMMLTarget> getKiePMMLTargets() {
        return this.kiePMMLTargets;
    }

    public void setKiePMMLTargets(List<KiePMMLTarget> kiePMMLTargets) {
        this.kiePMMLTargets = Collections.unmodifiableList(kiePMMLTargets);
    }

    public List<KiePMMLOutputField> getKiePMMLOutputFields() {
        return this.kiePMMLOutputFields != null ? Collections.unmodifiableList(this.kiePMMLOutputFields) : Collections.emptyList();
    }

    public KiePMMLTransformationDictionary getTransformationDictionary() {
        return this.transformationDictionary;
    }

    public KiePMMLLocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    public Map<String, Double> getProbabilityMap() {
        LinkedHashMap<String, Double> probabilityResultMap = this.getProbabilityResultMap();
        return probabilityResultMap != null ? Collections.unmodifiableMap(KiePMMLModel.getFixedProbabilityMap(probabilityResultMap)) : Collections.emptyMap();
    }

    public Object getPredictedDisplayValue() {
        return this.predictedDisplayValue;
    }

    protected void setPredictedDisplayValue(Object predictedDisplayValue) {
        this.predictedDisplayValue = predictedDisplayValue;
    }

    public Object getEntityId() {
        return this.entityId;
    }

    protected void setEntityId(Object entityId) {
        this.entityId = entityId;
    }

    public Object getAffinity() {
        return this.affinity;
    }

    protected void setAffinity(Object affinity) {
        this.affinity = affinity;
    }

    public abstract Object evaluate(Object var1, Map<String, Object> var2);

    protected abstract LinkedHashMap<String, Double> getProbabilityResultMap();

    private static LinkedHashMap<String, Double> getFixedProbabilityMap(LinkedHashMap<String, Double> probabilityResultMap) {
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = probabilityResultMap.keySet().toArray(new String[0]);
        AtomicReference<Double> sumCounter = new AtomicReference<Double>(0.0);
        for (int i = 0; i < probabilityResultMap.size(); ++i) {
            String key = resultMapKeys[i];
            double value = probabilityResultMap.get(key);
            if (i < resultMapKeys.length - 1) {
                sumCounter.accumulateAndGet(value, Double::sum);
                toReturn.put(key, value);
                continue;
            }
            toReturn.put(key, 1.0 - sumCounter.get());
        }
        return toReturn;
    }

    public static abstract class Builder<T extends KiePMMLModel>
    extends AbstractKiePMMLComponent.Builder<T> {
        protected Builder(String prefix, PMML_MODEL pmmlMODEL, MINING_FUNCTION miningFunction, Supplier<T> supplier) {
            super(prefix, supplier);
            ((KiePMMLModel)this.toBuild).pmmlMODEL = pmmlMODEL;
            ((KiePMMLModel)this.toBuild).miningFunction = miningFunction;
        }

        public Builder<T> withTargetField(String targetField) {
            ((KiePMMLModel)this.toBuild).targetField = targetField;
            return this;
        }

        public Builder<T> withOutputFieldsMap(Map<String, Object> outputFieldsMap) {
            if (outputFieldsMap != null) {
                ((KiePMMLModel)this.toBuild).outputFieldsMap.putAll(outputFieldsMap);
            }
            return this;
        }
    }
}

