/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLTarget;

public class KiePMMLModelWithSources
extends KiePMMLModel
implements HasSourcesMap {
    private static final long serialVersionUID = -7528313589316228283L;
    private final String kmodulePackageName;
    private final List<MiningField> miningFields;
    private final List<OutputField> outputFields;
    private final List<KiePMMLTarget> targetFields;
    private final Map<String, String> sourcesMap;

    public KiePMMLModelWithSources(String modelName, String kmodulePackageName, List<MiningField> miningFields, List<OutputField> outputFields, List<KiePMMLTarget> targetFields, Map<String, String> sourcesMap) {
        super(modelName, Collections.emptyList());
        this.kmodulePackageName = kmodulePackageName;
        this.miningFields = miningFields;
        this.outputFields = outputFields;
        this.targetFields = targetFields;
        this.sourcesMap = sourcesMap;
    }

    @Override
    public Object evaluate(Object knowledgeBase, Map<String, Object> requestData, PMMLContext context) {
        throw new KiePMMLException("KiePMMLModelWithSources is not meant to be used for actual evaluation");
    }

    @Override
    public List<MiningField> getMiningFields() {
        return this.miningFields;
    }

    @Override
    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public List<KiePMMLTarget> getTargetFields() {
        return this.targetFields;
    }

    @Override
    public Map<String, String> getSourcesMap() {
        return Collections.unmodifiableMap(this.sourcesMap);
    }

    @Override
    public void addSourceMap(String key, String value) {
        this.sourcesMap.put(key, value);
    }

    @Override
    public String getKModulePackageName() {
        return this.kmodulePackageName;
    }
}

