/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.commons.testingutility.PMMLContextTest;

public class KiePMMLModelWithSourcesTest {
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final String PACKAGE_NAME = "PACKAGE_NAME";
    private static final Map<String, String> SOURCES_MAP = new HashMap<String, String>();
    private KiePMMLModelWithSources kiePMMLModelWithSources;

    @Before
    public void setup() {
        this.kiePMMLModelWithSources = new KiePMMLModelWithSources(MODEL_NAME, PACKAGE_NAME, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), SOURCES_MAP, false);
    }

    @Test(expected=KiePMMLException.class)
    public void evaluate() {
        this.kiePMMLModelWithSources.evaluate((Object)"KB", Collections.EMPTY_MAP, (PMMLContext)new PMMLContextTest());
    }

    @Test
    public void getSourcesMap() {
        Assert.assertEquals(SOURCES_MAP, (Object)this.kiePMMLModelWithSources.getSourcesMap());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addToGetSourcesMap() {
        Map retrieved = this.kiePMMLModelWithSources.getSourcesMap();
        retrieved.put("KEY", "VALUE");
    }

    @Test
    public void addSourceMap() {
        Map retrieved = this.kiePMMLModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.kiePMMLModelWithSources.addSourceMap("KEY", "VALUE");
        retrieved = this.kiePMMLModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.containsKey("KEY"));
        Assert.assertEquals((Object)"VALUE", retrieved.get("KEY"));
    }
}

