/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.Collection;
import java.util.stream.Collectors;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;
import org.kie.pmml.api.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModelFactory;

public class PMMLLoaderUtils {
    private PMMLLoaderUtils() {
    }

    public static Collection<KiePMMLModelFactory> loadAllKiePMMLModelFactories(Collection<GeneratedExecutableResource> finalResources, PMMLContext pmmlContext) {
        return finalResources.stream().map(finalResource -> PMMLLoaderUtils.loadKiePMMLModelFactory(finalResource, pmmlContext)).collect(Collectors.toSet());
    }

    public static KiePMMLModelFactory loadKiePMMLModelFactory(FRI fri, PMMLContext pmmlContext) {
        GeneratedExecutableResource finalResource = (GeneratedExecutableResource)GeneratedResourceUtils.getGeneratedExecutableResource((FRI)fri, (String)"pmml").orElseThrow(() -> new KieRuntimeServiceException("Can not find expected GeneratedExecutableResource for " + fri));
        return PMMLLoaderUtils.loadKiePMMLModelFactory(finalResource, pmmlContext);
    }

    public static KiePMMLModelFactory loadKiePMMLModelFactory(GeneratedExecutableResource finalResource, PMMLContext pmmlContext) {
        try {
            String fullKiePMMLModelFactorySourceClassName = (String)finalResource.getFullClassNames().get(0);
            Class aClass = pmmlContext.loadClass(fullKiePMMLModelFactorySourceClassName);
            return (KiePMMLModelFactory)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new KieRuntimeServiceException((Throwable)e);
        }
    }
}

