/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.enums.ARRAY_TYPE;
import org.kie.pmml.commons.model.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.commons.model.enums.DATA_TYPE;
import org.kie.pmml.commons.model.enums.IN_NOTIN;
import org.kie.pmml.commons.model.enums.OPERATOR;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLFalsePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLTruePredicate;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLPredicateFactory {
    static final String KIE_PMML_SIMPLE_PREDICATE_TEMPLATE_JAVA = "KiePMMLSimplePredicateTemplate.tmpl";
    static final String KIE_PMML_SIMPLE_PREDICATE_TEMPLATE = "KiePMMLSimplePredicateTemplate";
    static final String KIE_PMML_SIMPLE_SET_PREDICATE_TEMPLATE_JAVA = "KiePMMLSimpleSetPredicateTemplate.tmpl";
    static final String KIE_PMML_SIMPLE_SET_PREDICATE_TEMPLATE = "KiePMMLSimpleSetPredicateTemplate";
    static final String KIE_PMML_COMPOUND_PREDICATE_TEMPLATE_JAVA = "KiePMMLCompoundPredicateTemplate.tmpl";
    static final String KIE_PMML_COMPOUND_PREDICATE_TEMPLATE = "KiePMMLCompoundPredicateTemplate";
    static final String KIE_PMML_OPERATOR_FUNCTION_TEMPLATE = "KiePMMLOperatorFunctionTemplate.tmpl";
    static final String KIE_PMML_OPERATOR_FUNCTION = "KiePMMLOperatorFunctionTemplate";
    static final String KIE_PMML_TRUE_PREDICATE_TEMPLATE_JAVA = "KiePMMLTruePredicateTemplate.tmpl";
    static final String KIE_PMML_TRUE_PREDICATE_TEMPLATE = "KiePMMLTruePredicateTemplate";
    static final String KIE_PMML_FALSE_PREDICATE_TEMPLATE_JAVA = "KiePMMLFalsePredicateTemplate.tmpl";
    static final String KIE_PMML_FALSE_PREDICATE_TEMPLATE = "KiePMMLFalsePredicateTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLPredicateFactory.class.getName());

    private KiePMMLPredicateFactory() {
    }

    public static List<KiePMMLPredicate> getPredicates(List<Predicate> predicates, DataDictionary dataDictionary) {
        logger.info("getPredicates {}", predicates);
        return predicates.stream().map(predicate -> KiePMMLPredicateFactory.getPredicate(predicate, dataDictionary)).collect(Collectors.toList());
    }

    public static KiePMMLPredicate getPredicate(Predicate predicate, DataDictionary dataDictionary) {
        logger.info("getPredicate {}", (Object)predicate);
        if (predicate instanceof SimplePredicate) {
            DataType dataType = dataDictionary.getDataFields().stream().filter(dataField -> dataField.getName().getValue().equals(((SimplePredicate)predicate).getField().getValue())).map(DataField::getDataType).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find DataField for predicate " + ((SimplePredicate)predicate).getField().getValue()));
            return KiePMMLPredicateFactory.getKiePMMLSimplePredicate((SimplePredicate)predicate, dataType);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return KiePMMLPredicateFactory.getKiePMMLSimpleSetPredicate((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof CompoundPredicate) {
            return KiePMMLPredicateFactory.getKiePMMLCompoundPredicate((CompoundPredicate)predicate, dataDictionary);
        }
        if (predicate instanceof True) {
            return KiePMMLPredicateFactory.getKiePMMLTruePredicate();
        }
        if (predicate instanceof False) {
            return KiePMMLPredicateFactory.getKiePMMLFalsePredicate();
        }
        throw new KiePMMLException("Predicate of type " + predicate.getClass().getName() + " not managed, yet");
    }

    public static KiePMMLSimplePredicate getKiePMMLSimplePredicate(SimplePredicate predicate, DataType dataType) {
        return (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)predicate.getField().getValue(), Collections.emptyList(), (OPERATOR)OPERATOR.byName((String)predicate.getOperator().value())).withValue(KiePMMLPredicateFactory.getActualValue(predicate.getValue(), dataType)).build();
    }

    public static KiePMMLSimpleSetPredicate getKiePMMLSimpleSetPredicate(SimpleSetPredicate predicate) {
        List<Object> values = KiePMMLPredicateFactory.getObjectsFromArray(predicate.getArray());
        return (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)predicate.getField().getValue(), Collections.emptyList(), (ARRAY_TYPE)ARRAY_TYPE.byName((String)predicate.getArray().getType().value()), (IN_NOTIN)IN_NOTIN.byName((String)predicate.getBooleanOperator().value())).withValues(values).build();
    }

    public static KiePMMLCompoundPredicate getKiePMMLCompoundPredicate(CompoundPredicate predicate, DataDictionary dataDictionary) {
        return (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)BOOLEAN_OPERATOR.byName((String)predicate.getBooleanOperator().value())).withKiePMMLPredicates(KiePMMLPredicateFactory.getPredicates(predicate.getPredicates(), dataDictionary)).build();
    }

    public static KiePMMLTruePredicate getKiePMMLTruePredicate() {
        return (KiePMMLTruePredicate)KiePMMLTruePredicate.builder(Collections.emptyList()).build();
    }

    public static KiePMMLFalsePredicate getKiePMMLFalsePredicate() {
        return (KiePMMLFalsePredicate)KiePMMLFalsePredicate.builder(Collections.emptyList()).build();
    }

    public static Map<String, String> getPredicateSourcesMap(KiePMMLPredicate kiePMMLPredicate, String packageName) {
        logger.info("getPredicateSourcesMap {}", (Object)kiePMMLPredicate);
        if (kiePMMLPredicate instanceof KiePMMLSimplePredicate) {
            return KiePMMLPredicateFactory.getKiePMMLSimplePredicateSourcesMap((KiePMMLSimplePredicate)kiePMMLPredicate, packageName);
        }
        if (kiePMMLPredicate instanceof KiePMMLSimpleSetPredicate) {
            return KiePMMLPredicateFactory.getKiePMMLSimpleSetPredicateSourcesMap((KiePMMLSimpleSetPredicate)kiePMMLPredicate, packageName);
        }
        if (kiePMMLPredicate instanceof KiePMMLCompoundPredicate) {
            return KiePMMLPredicateFactory.getKiePMMLCompoundPredicateSourcesMap((KiePMMLCompoundPredicate)kiePMMLPredicate, packageName);
        }
        if (kiePMMLPredicate instanceof KiePMMLTruePredicate) {
            return KiePMMLPredicateFactory.getKiePMMLTruePredicateSourcesMap((KiePMMLTruePredicate)kiePMMLPredicate, packageName);
        }
        if (kiePMMLPredicate instanceof KiePMMLFalsePredicate) {
            return KiePMMLPredicateFactory.getKiePMMLFalsePredicateSourcesMap((KiePMMLFalsePredicate)kiePMMLPredicate, packageName);
        }
        throw new KiePMMLException("Predicate of type " + kiePMMLPredicate.getClass().getName() + " not managed, yet");
    }

    static Map<String, String> getKiePMMLSimplePredicateSourcesMap(KiePMMLSimplePredicate kiePMMLSimplePredicate, String packageName) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLSimplePredicate.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit(className, packageName, KIE_PMML_SIMPLE_PREDICATE_TEMPLATE_JAVA, KIE_PMML_SIMPLE_PREDICATE_TEMPLATE);
        ClassOrInterfaceDeclaration predicateTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)predicateTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", predicateTemplate.getName())));
        KiePMMLPredicateFactory.setSimplePredicateConstructor(className, kiePMMLSimplePredicate.getName(), constructorDeclaration, kiePMMLSimplePredicate.getOperator(), kiePMMLSimplePredicate.getValue());
        return Collections.singletonMap(JavaParserUtils.getFullClassName(cloneCU), cloneCU.toString());
    }

    static Map<String, String> getKiePMMLSimpleSetPredicateSourcesMap(KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicate, String packageName) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLSimpleSetPredicate.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit(className, packageName, KIE_PMML_SIMPLE_SET_PREDICATE_TEMPLATE_JAVA, KIE_PMML_SIMPLE_SET_PREDICATE_TEMPLATE);
        ClassOrInterfaceDeclaration predicateTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)predicateTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", predicateTemplate.getName())));
        KiePMMLPredicateFactory.setSimpleSetPredicateConstructor(className, kiePMMLSimpleSetPredicate.getName(), constructorDeclaration, kiePMMLSimpleSetPredicate.getArrayType(), kiePMMLSimpleSetPredicate.getInNotIn(), kiePMMLSimpleSetPredicate.getValues());
        return Collections.singletonMap(JavaParserUtils.getFullClassName(cloneCU), cloneCU.toString());
    }

    static Map<String, String> getKiePMMLCompoundPredicateSourcesMap(KiePMMLCompoundPredicate kiePMMLCompoundPredicate, String packageName) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLCompoundPredicate.getId());
        HashMap<String, String> toReturn = new HashMap<String, String>();
        if (kiePMMLCompoundPredicate.getKiePMMLPredicates() != null) {
            kiePMMLCompoundPredicate.getKiePMMLPredicates().forEach(kiePMMLPredicate -> toReturn.putAll(KiePMMLPredicateFactory.getPredicateSourcesMap(kiePMMLPredicate, packageName)));
        }
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit(className, packageName, KIE_PMML_COMPOUND_PREDICATE_TEMPLATE_JAVA, KIE_PMML_COMPOUND_PREDICATE_TEMPLATE);
        ClassOrInterfaceDeclaration predicateTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)predicateTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", predicateTemplate.getName())));
        HashSet<String> predicatesClasses = new HashSet();
        if (kiePMMLCompoundPredicate.getKiePMMLPredicates() != null) {
            predicatesClasses = kiePMMLCompoundPredicate.getKiePMMLPredicates().stream().map(predicate -> packageName + "." + KiePMMLModelUtils.getSanitizedClassName((String)predicate.getId())).collect(Collectors.toSet());
        }
        if (!toReturn.keySet().containsAll(predicatesClasses)) {
            String missingClasses = String.join((CharSequence)", ", predicatesClasses);
            throw new KiePMMLException("Expected generated class " + missingClasses + " not found");
        }
        KiePMMLPredicateFactory.setCompoundPredicateConstructor(className, kiePMMLCompoundPredicate.getName(), constructorDeclaration, kiePMMLCompoundPredicate.getBooleanOperator(), predicatesClasses);
        toReturn.put(JavaParserUtils.getFullClassName(cloneCU), cloneCU.toString());
        return toReturn;
    }

    static Map<String, String> getKiePMMLTruePredicateSourcesMap(KiePMMLTruePredicate kiePMMLTruePredicate, String packageName) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLTruePredicate.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit(className, packageName, KIE_PMML_TRUE_PREDICATE_TEMPLATE_JAVA, KIE_PMML_TRUE_PREDICATE_TEMPLATE);
        ClassOrInterfaceDeclaration predicateTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)predicateTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", predicateTemplate.getName())));
        KiePMMLPredicateFactory.setTrueFalsePredicateConstructor(className, kiePMMLTruePredicate.getName(), constructorDeclaration);
        return Collections.singletonMap(JavaParserUtils.getFullClassName(cloneCU), cloneCU.toString());
    }

    static Map<String, String> getKiePMMLFalsePredicateSourcesMap(KiePMMLFalsePredicate kiePMMLFalsePredicate, String packageName) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLFalsePredicate.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit(className, packageName, KIE_PMML_FALSE_PREDICATE_TEMPLATE_JAVA, KIE_PMML_FALSE_PREDICATE_TEMPLATE);
        ClassOrInterfaceDeclaration predicateTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)predicateTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", predicateTemplate.getName())));
        KiePMMLPredicateFactory.setTrueFalsePredicateConstructor(className, kiePMMLFalsePredicate.getName(), constructorDeclaration);
        return Collections.singletonMap(JavaParserUtils.getFullClassName(cloneCU), cloneCU.toString());
    }

    static void setSimplePredicateConstructor(String generatedClassName, String predicateName, ConstructorDeclaration constructorDeclaration, OPERATOR operator, Object value) {
        if (operator.equals((Object)OPERATOR.IS_MISSING) || operator.equals((Object)OPERATOR.IS_NOT_MISSING)) {
            throw new IllegalArgumentException(operator + " not supported, yet");
        }
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, predicateName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationArgument(superStatement, "operator", operator.getClass().getCanonicalName() + "." + operator.name());
        StringLiteralExpr expression = value instanceof String ? new StringLiteralExpr((String)value) : new NameExpr(value.toString());
        CommonCodegenUtils.setAssignExpressionValue(body, "value", (Expression)expression);
    }

    static void setSimpleSetPredicateConstructor(String generatedClassName, String predicateName, ConstructorDeclaration constructorDeclaration, ARRAY_TYPE arrayType, IN_NOTIN inNotIn, List<Object> values) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, predicateName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationArgument(superStatement, "arrayType", arrayType.getClass().getCanonicalName() + "." + arrayType.name());
        CommonCodegenUtils.setExplicitConstructorInvocationArgument(superStatement, "inNotIn", inNotIn.getClass().getCanonicalName() + "." + inNotIn.name());
        AssignExpr assignExpr = CommonCodegenUtils.getAssignExpression(body, "values").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "values", body)));
        ClassOrInterfaceType arrayClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(arrayClass);
        assignExpr.setValue((Expression)objectCreationExpr);
        for (Object value : values) {
            Object valueExpression = arrayType == ARRAY_TYPE.STRING ? new StringLiteralExpr(value.toString()) : new NameExpr(value.toString());
            NodeList arguments = NodeList.nodeList((Node[])new Expression[]{valueExpression});
            MethodCallExpr methodCallExpr = new MethodCallExpr();
            methodCallExpr.setScope((Expression)assignExpr.getTarget().asNameExpr());
            methodCallExpr.setName("add");
            methodCallExpr.setArguments(arguments);
            ExpressionStmt expressionStmt = new ExpressionStmt();
            expressionStmt.setExpression((Expression)methodCallExpr);
            body.addStatement((Statement)expressionStmt);
        }
    }

    static void setCompoundPredicateConstructor(String generatedClassName, String predicateName, ConstructorDeclaration constructorDeclaration, BOOLEAN_OPERATOR booleanOperator, Set<String> predicatesClasses) {
        if (booleanOperator.equals((Object)BOOLEAN_OPERATOR.SURROGATE)) {
            throw new IllegalArgumentException(BOOLEAN_OPERATOR.SURROGATE + " not supported, yet");
        }
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, predicateName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationArgument(superStatement, "booleanOperator", booleanOperator.getClass().getCanonicalName() + "." + booleanOperator.name());
        AssignExpr assignExpr = CommonCodegenUtils.getAssignExpression(body, "operatorFunction").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "operatorFunction", body)));
        CompilationUnit operatorFunctionCU = JavaParserUtils.getFromFileName(KIE_PMML_OPERATOR_FUNCTION_TEMPLATE).clone();
        ClassOrInterfaceDeclaration operatorFunctionClass = (ClassOrInterfaceDeclaration)operatorFunctionCU.getClassByName(KIE_PMML_OPERATOR_FUNCTION).orElseThrow(() -> new KiePMMLException("Main class not found"));
        String methodName = "getInnerBinaryOperator" + booleanOperator.name();
        MethodDeclaration methodDeclaration = CommonCodegenUtils.getMethodDeclaration(operatorFunctionClass, methodName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected method '%s' in class %s", methodName, operatorFunctionClass)));
        BlockStmt methodBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing expected body in method %s", methodDeclaration)));
        ReturnStmt returnStmt = methodBody.getStatements().stream().filter(statement -> statement instanceof ReturnStmt).map(statement -> (ReturnStmt)statement).findFirst().orElseThrow(() -> new KiePMMLException(String.format("Missing expected return in method %s", methodDeclaration)));
        Expression expression = (Expression)returnStmt.getExpression().orElseThrow(() -> new KiePMMLException(String.format("Missing expected expression in return %s", returnStmt)));
        assignExpr.setValue(expression);
        assignExpr = CommonCodegenUtils.getAssignExpression(body, "kiePMMLPredicates").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "kiePMMLPredicates", body)));
        ClassOrInterfaceType arrayClass = StaticJavaParser.parseClassOrInterfaceType((String)ArrayList.class.getName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(arrayClass);
        assignExpr.setValue((Expression)objectCreationExpr);
        for (String predicateClass : predicatesClasses) {
            ClassOrInterfaceType kiePMMLPredicateClass = StaticJavaParser.parseClassOrInterfaceType((String)predicateClass);
            objectCreationExpr = new ObjectCreationExpr();
            objectCreationExpr.setType(kiePMMLPredicateClass);
            NodeList arguments = NodeList.nodeList((Node[])new Expression[]{objectCreationExpr});
            MethodCallExpr methodCallExpr = new MethodCallExpr();
            methodCallExpr.setScope((Expression)assignExpr.getTarget().asNameExpr());
            methodCallExpr.setName("add");
            methodCallExpr.setArguments(arguments);
            ExpressionStmt expressionStmt = new ExpressionStmt();
            expressionStmt.setExpression((Expression)methodCallExpr);
            body.addStatement((Statement)expressionStmt);
        }
    }

    static void setTrueFalsePredicateConstructor(String generatedClassName, String predicateName, ConstructorDeclaration constructorDeclaration) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, predicateName);
    }

    static List<Object> getObjectsFromArray(Array source) {
        String[] valuesArray;
        Array.Type type = source.getType();
        ArrayList<Object> toReturn = new ArrayList<Object>();
        String stringValue = (String)source.getValue();
        block5: for (String s : valuesArray = stringValue.split(" ")) {
            switch (type) {
                case INT: {
                    toReturn.add(Integer.valueOf(s));
                    continue block5;
                }
                case STRING: {
                    toReturn.add(s);
                    continue block5;
                }
                case REAL: {
                    toReturn.add(Double.valueOf(s));
                    continue block5;
                }
                default: {
                    throw new KiePMMLException("Unknown Array " + type);
                }
            }
        }
        return toReturn;
    }

    private static Object getActualValue(Object rawValue, DataType dataType) {
        DATA_TYPE dataTypePmml = DATA_TYPE.byName((String)dataType.value());
        return dataTypePmml.getActualValue(rawValue);
    }
}

