/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.builders;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class KiePMMLModelCodegenUtils {
    private KiePMMLModelCodegenUtils() {
    }

    public static void init(ClassOrInterfaceDeclaration modelTemplate, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Model pmmlModel) {
        NullLiteralExpr miningFunctionExpression;
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        String name = pmmlModel.getModelName();
        String generatedClassName = KiePMMLModelUtils.getSanitizedClassName((String)name);
        List<MiningField> miningFields = ModelUtils.convertToKieMiningFieldList(pmmlModel.getMiningSchema(), dataDictionary);
        List<OutputField> outputFields = ModelUtils.convertToKieOutputFieldList(pmmlModel.getOutput(), dataDictionary);
        List<KiePMMLOutputField> kiePMMLOutputFields = KiePMMLOutputFieldFactory.getOutputFields(pmmlModel);
        if (pmmlModel.getMiningFunction() != null) {
            MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)pmmlModel.getMiningFunction().value());
            miningFunctionExpression = new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name());
        } else {
            miningFunctionExpression = new NullLiteralExpr();
        }
        PMML_MODEL pmmlModelEnum = PMML_MODEL.byName((String)pmmlModel.getClass().getSimpleName());
        NameExpr pmmlMODELExpression = new NameExpr(pmmlModelEnum.getClass().getName() + "." + pmmlModelEnum.name());
        String targetFieldName = ModelUtils.getTargetFieldName(dataDictionary, pmmlModel).orElse(null);
        Object targetFieldExpression = targetFieldName != null ? new StringLiteralExpr(targetFieldName) : new NullLiteralExpr();
        KiePMMLModelFactoryUtils.setKiePMMLModelConstructor(generatedClassName, constructorDeclaration, name, miningFields, outputFields);
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration(modelTemplate, transformationDictionary, pmmlModel.getLocalTransformations());
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue(body, "pmmlMODEL", (Expression)pmmlMODELExpression);
        CommonCodegenUtils.setAssignExpressionValue(body, "miningFunction", (Expression)miningFunctionExpression);
        CommonCodegenUtils.setAssignExpressionValue(body, "targetField", (Expression)targetFieldExpression);
        KiePMMLModelFactoryUtils.addKiePMMLOutputFieldsPopulation(body, kiePMMLOutputFields);
    }
}

