/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLLocalTransformationsFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTransformationDictionaryFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class KiePMMLModelFactoryUtils {
    public static final String GET_CREATED_KIEPMMLOUTPUTFIELDS = "getCreatedKiePMMLOutputFields";

    private KiePMMLModelFactoryUtils() {
    }

    public static void setConstructorSuperNameInvocation(String generatedClassName, ConstructorDeclaration constructorDeclaration, String name) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument(superStatement, "name", String.format("\"%s\"", name));
    }

    public static void setKiePMMLModelConstructor(String generatedClassName, ConstructorDeclaration constructorDeclaration, String name, List<MiningField> miningFields, List<OutputField> outputFields, Map<String, Pair<DATA_TYPE, String>> missingValueReplacements) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation(generatedClassName, constructorDeclaration, name);
        BlockStmt body = constructorDeclaration.getBody();
        List<ObjectCreationExpr> miningFieldsObjectCreations = KiePMMLModelFactoryUtils.getMiningFieldsObjectCreations(miningFields);
        CommonCodegenUtils.addListPopulation(miningFieldsObjectCreations, body, "miningFields");
        List<ObjectCreationExpr> outputFieldsObjectCreations = KiePMMLModelFactoryUtils.getOutputFieldsObjectCreations(outputFields);
        CommonCodegenUtils.addListPopulation(outputFieldsObjectCreations, body, "outputFields");
        Map<String, Expression> missingValueReplacementsExpr = missingValueReplacements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> CommonCodegenUtils.literalExprFrom((DATA_TYPE)((Pair)entry.getValue()).a, (String)((Pair)entry.getValue()).b)));
        CommonCodegenUtils.addMapPopulationExpressions(missingValueReplacementsExpr, body, "missingValueReplacementMap");
    }

    public static void addGetCreatedKiePMMLOutputFieldsMethod(ClassOrInterfaceDeclaration modelTemplate, List<org.dmg.pmml.OutputField> outputFields) {
        MethodDeclaration methodDeclaration = modelTemplate.addMethod(GET_CREATED_KIEPMMLOUTPUTFIELDS, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
        ClassOrInterfaceType returnedType = CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getSimpleName(), Collections.singletonList(KiePMMLOutputField.class.getSimpleName()));
        methodDeclaration.setType((Type)returnedType);
        BlockStmt body = new BlockStmt();
        methodDeclaration.setBody(body);
        NodeList arguments = new NodeList();
        for (org.dmg.pmml.OutputField outputField : outputFields) {
            String outputFieldVariableName = KiePMMLModelUtils.getSanitizedClassName((String)outputField.getName().getValue()).toLowerCase();
            BlockStmt toAdd = KiePMMLOutputFieldFactory.getOutputFieldVariableDeclaration(outputFieldVariableName, outputField);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
            arguments.add((Node)new NameExpr(outputFieldVariableName));
        }
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
        methodCallExpr.setName("asList");
        methodCallExpr.setArguments(arguments);
        ReturnStmt returnStmt = new ReturnStmt();
        returnStmt.setExpression((Expression)methodCallExpr);
        body.addStatement((Statement)returnStmt);
    }

    public static void addTransformationsInClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration toPopulate, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        String createTransformationDictionary = null;
        if (transformationDictionary != null) {
            BlockStmt createTransformationDictionaryBody = KiePMMLTransformationDictionaryFactory.getKiePMMLTransformationDictionaryVariableDeclaration(transformationDictionary);
            createTransformationDictionaryBody.addStatement((Statement)CommonCodegenUtils.getReturnStmt("transformationDictionary"));
            createTransformationDictionary = "createTransformationDictionary";
            MethodDeclaration createTransformationDictionaryMethod = toPopulate.addMethod(createTransformationDictionary, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            createTransformationDictionaryMethod.setType(KiePMMLTransformationDictionary.class.getName());
            createTransformationDictionaryMethod.setBody(createTransformationDictionaryBody);
        }
        String createLocalTransformations = null;
        if (localTransformations != null) {
            BlockStmt createLocalTransformationsBody = KiePMMLLocalTransformationsFactory.getKiePMMLLocalTransformationsVariableDeclaration(localTransformations);
            createLocalTransformationsBody.addStatement((Statement)CommonCodegenUtils.getReturnStmt("localTransformations"));
            createLocalTransformations = "createLocalTransformations";
            MethodDeclaration createLocalTransformationsMethod = toPopulate.addMethod(createLocalTransformations, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            createLocalTransformationsMethod.setType(KiePMMLLocalTransformations.class.getName());
            createLocalTransformationsMethod.setBody(createLocalTransformationsBody);
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)toPopulate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", toPopulate.getName())));
        KiePMMLModelFactoryUtils.populateTransformationsInConstructor(constructorDeclaration, createTransformationDictionary, createLocalTransformations);
    }

    static List<ObjectCreationExpr> getMiningFieldsObjectCreations(List<MiningField> miningFields) {
        return miningFields.stream().map(miningField -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(MiningField.class.getCanonicalName());
            StringLiteralExpr name = miningField.getName() != null ? new StringLiteralExpr(miningField.getName()) : new NullLiteralExpr();
            FIELD_USAGE_TYPE fieldUsageType = miningField.getUsageType();
            NameExpr usageType = fieldUsageType != null ? new NameExpr(fieldUsageType.getClass().getName() + "." + fieldUsageType.name()) : new NullLiteralExpr();
            OP_TYPE oPT = miningField.getOpType();
            NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
            DATA_TYPE dtT = miningField.getDataType();
            NameExpr dataType = dtT != null ? new NameExpr(dtT.getClass().getName() + "." + dtT.name()) : new NullLiteralExpr();
            StringLiteralExpr missingValueReplacement = miningField.getMissingValueReplacement() != null ? new StringLiteralExpr(miningField.getMissingValueReplacement()) : new NullLiteralExpr();
            NullLiteralExpr allowedValues = miningField.getAllowedValues() != null ? CommonCodegenUtils.createArraysAsListFromList(miningField.getAllowedValues()).getExpression() : new NullLiteralExpr();
            NullLiteralExpr intervals = miningField.getIntervals() != null ? KiePMMLModelFactoryUtils.createIntervalsExpression(miningField.getIntervals()) : new NullLiteralExpr();
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{name, usageType, opType, dataType, missingValueReplacement, allowedValues, intervals}));
            return toReturn;
        }).collect(Collectors.toList());
    }

    static Expression createIntervalsExpression(List<Interval> intervals) {
        ExpressionStmt arraysAsListStmt = CommonCodegenUtils.createArraysAsListExpression();
        MethodCallExpr arraysCallExpression = arraysAsListStmt.getExpression().asMethodCallExpr();
        NodeList arguments = new NodeList();
        intervals.forEach(value -> arguments.add((Node)KiePMMLModelFactoryUtils.getObjectCreationExprFromInterval(value)));
        arraysCallExpression.setArguments(arguments);
        arraysAsListStmt.setExpression((Expression)arraysCallExpression);
        return arraysAsListStmt.getExpression();
    }

    static ObjectCreationExpr getObjectCreationExprFromInterval(Interval source) {
        ObjectCreationExpr toReturn = new ObjectCreationExpr();
        toReturn.setType(Interval.class.getCanonicalName());
        NodeList arguments = new NodeList();
        if (source.getLeftMargin() != null) {
            arguments.add((Node)new NameExpr(source.getLeftMargin().toString()));
        } else {
            arguments.add((Node)new NullLiteralExpr());
        }
        if (source.getRightMargin() != null) {
            arguments.add((Node)new NameExpr(source.getRightMargin().toString()));
        } else {
            arguments.add((Node)new NullLiteralExpr());
        }
        toReturn.setArguments(arguments);
        return toReturn;
    }

    static List<ObjectCreationExpr> getOutputFieldsObjectCreations(List<OutputField> outputFields) {
        return outputFields.stream().map(outputField -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(OutputField.class.getCanonicalName());
            StringLiteralExpr name = outputField.getName() != null ? new StringLiteralExpr(outputField.getName()) : new NullLiteralExpr();
            OP_TYPE oPT = outputField.getOpType();
            NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
            DATA_TYPE datT = outputField.getDataType();
            NameExpr dataType = datT != null ? new NameExpr(datT.getClass().getName() + "." + datT.name()) : new NullLiteralExpr();
            StringLiteralExpr targetField = outputField.getTargetField() != null ? new StringLiteralExpr(outputField.getTargetField()) : new NullLiteralExpr();
            RESULT_FEATURE rsltF = outputField.getResultFeature();
            NameExpr resultFeature = rsltF != null ? new NameExpr(rsltF.getClass().getName() + "." + rsltF.name()) : new NullLiteralExpr();
            NullLiteralExpr allowedValues = outputField.getAllowedValues() != null ? CommonCodegenUtils.createArraysAsListFromList(outputField.getAllowedValues()).getExpression() : new NullLiteralExpr();
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{name, opType, dataType, targetField, resultFeature, allowedValues}));
            return toReturn;
        }).collect(Collectors.toList());
    }

    static void populateTransformationsInConstructor(ConstructorDeclaration constructorDeclaration, String createTransformationDictionary, String createLocalTransformations) {
        MethodCallExpr createTransformationDictionaryInitializer = createTransformationDictionary != null ? new MethodCallExpr((Expression)new NameExpr("this"), createTransformationDictionary, NodeList.nodeList((Node[])new Expression[0])) : new NullLiteralExpr();
        CommonCodegenUtils.setAssignExpressionValue(constructorDeclaration.getBody(), "transformationDictionary", (Expression)createTransformationDictionaryInitializer);
        MethodCallExpr createLocalTransformationsInitializer = createLocalTransformations != null ? new MethodCallExpr((Expression)new NameExpr("this"), createLocalTransformations, NodeList.nodeList((Node[])new Expression[0])) : new NullLiteralExpr();
        CommonCodegenUtils.setAssignExpressionValue(constructorDeclaration.getBody(), "localTransformations", (Expression)createLocalTransformationsInitializer);
    }
}

