/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Row;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.w3c.dom.Element;

public class KiePMMLRowFactory {
    static final String KIE_PMML_ROW_TEMPLATE_JAVA = "KiePMMLRowTemplate.tmpl";
    static final String KIE_PMML_ROW_TEMPLATE = "KiePMMLRowTemplate";
    static final String GETKIEPMMLROW = "getKiePMMLRow";
    static final String ROW = "row";
    static final String COLUMN_VALUES = "columnValues";
    static final ClassOrInterfaceDeclaration ROW_TEMPLATE;

    private KiePMMLRowFactory() {
    }

    static BlockStmt getRowVariableDeclaration(String variableName, Row row) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)ROW_TEMPLATE.getMethodsByName(GETKIEPMMLROW).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        String columnValuesVariableName = String.format("%s_%s", variableName, COLUMN_VALUES);
        VariableDeclarator columnValuesVariableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, COLUMN_VALUES).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", ROW, toReturn)));
        columnValuesVariableDeclarator.setName(columnValuesVariableName);
        MethodCallExpr columnValuesVariableInit = ((Expression)columnValuesVariableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", COLUMN_VALUES, toReturn)))).asMethodCallExpr();
        MethodCallExpr columnValuesVariableScope = ((Expression)columnValuesVariableInit.getScope().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", COLUMN_VALUES, toReturn)))).asMethodCallExpr();
        ArrayCreationExpr columnValuesVariableArray = ((Expression)columnValuesVariableScope.getArguments().get(0)).asArrayCreationExpr();
        ArrayInitializerExpr columnValuesVariableArrayInit = ((ArrayInitializerExpr)columnValuesVariableArray.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", COLUMN_VALUES, toReturn)))).asArrayInitializerExpr();
        Map<String, Object> rowDataMap = KiePMMLRowFactory.getRowDataMap(row);
        NodeList arguments = new NodeList();
        rowDataMap.entrySet().forEach(entry -> {
            ArrayInitializerExpr argument = new ArrayInitializerExpr();
            NodeList values = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)entry.getKey()), CommonCodegenUtils.getExpressionForObject(entry.getValue())});
            argument.setValues(values);
            arguments.add((Node)argument);
        });
        columnValuesVariableArrayInit.setValues(arguments);
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, ROW).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", ROW, toReturn)));
        variableDeclarator.setName(variableName);
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", ROW, toReturn)))).asObjectCreationExpr();
        NameExpr nameExpr = new NameExpr(columnValuesVariableName);
        objectCreationExpr.getArguments().set(0, (Node)nameExpr);
        return toReturn;
    }

    static Map<String, Object> getRowDataMap(Row source) {
        List<Element> elements = source.getContent().stream().filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        elements.forEach(el -> KiePMMLRowFactory.populateWithElement(toReturn, el));
        return toReturn;
    }

    static void populateWithElement(Map<String, Object> toPopulate, Element source) {
        toPopulate.put(source.getTagName(), source.getFirstChild().getTextContent());
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_ROW_TEMPLATE_JAVA);
        ROW_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_ROW_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLRowTemplate"));
        ((MethodDeclaration)ROW_TEMPLATE.getMethodsByName(GETKIEPMMLROW).get(0)).clone();
    }
}

