/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.utils.SourceUtils;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.transformations.KiePMMLLocalTransformations;
import org.kie.pmml.commons.transformations.KiePMMLTransformationDictionary;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.factories.KiePMMLLocalTransformationsInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLMiningFieldInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLOutputFieldInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLTargetInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLTransformationDictionaryInstanceFactory;

public abstract class AbstractSpecificCompilationDTO<T extends Model>
implements CompilationDTO<T> {
    private static final long serialVersionUID = -3691191496300060907L;
    private final CompilationDTO<T> source;
    private final List<Field<?>> fields;
    private List<KiePMMLMiningField> kiePMMLMiningFields;
    private List<KiePMMLOutputField> kiePMMLOutputFields;
    private List<KiePMMLTarget> kiePMMLTargets;
    private KiePMMLTransformationDictionary kiePMMLTransformationDictionary = null;
    private KiePMMLLocalTransformations kiePMMLLocalTransformations = null;

    protected AbstractSpecificCompilationDTO(PMML pmml, T model, HasClassLoader hasClassloader, String packageName, List<Field<?>> fields) {
        this((CompilationDTO<T>)CommonCompilationDTO.fromPackageNameAndFields((PMML)pmml, model, (HasClassLoader)hasClassloader, (String)packageName, fields));
    }

    protected AbstractSpecificCompilationDTO(CompilationDTO<T> source) {
        this.source = source;
        this.fields = new ArrayList(source.getFields());
    }

    public PMML getPmml() {
        return this.source.getPmml();
    }

    public TransformationDictionary getTransformationDictionary() {
        return this.source.getTransformationDictionary();
    }

    public T getModel() {
        return (T)this.source.getModel();
    }

    public MiningSchema getMiningSchema() {
        return this.source.getMiningSchema();
    }

    public MiningFunction getMiningFunction() {
        return this.source.getMiningFunction();
    }

    public LocalTransformations getLocalTransformations() {
        return this.source.getLocalTransformations();
    }

    public Output getOutput() {
        return this.source.getOutput();
    }

    public Targets getTargets() {
        return this.source.getTargets();
    }

    public List<Field<?>> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public DataField getTargetDataField() {
        return this.source.getTargetDataField();
    }

    public OpType getOpType() {
        return this.source.getOpType();
    }

    public String getModelName() {
        return this.source.getModelName();
    }

    public String getTargetFieldName() {
        return this.source.getTargetFieldName();
    }

    public String getPackageName() {
        return this.source.getPackageName();
    }

    public String getSimpleClassName() {
        return this.source.getSimpleClassName();
    }

    public String getPackageCanonicalClassName() {
        return this.source.getPackageCanonicalClassName();
    }

    public Class<?> compileAndLoadClass(Map<String, String> sourcesMap) {
        try {
            SourceUtils.dumpSources(sourcesMap, (PMML_MODEL)this.source.getPMML_MODEL());
            return this.source.compileAndLoadClass(sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public HasClassLoader getHasClassloader() {
        return this.source.getHasClassloader();
    }

    public PMML_MODEL getPMML_MODEL() {
        return this.source.getPMML_MODEL();
    }

    public MINING_FUNCTION getMINING_FUNCTION() {
        return this.source.getMINING_FUNCTION();
    }

    public List<MiningField> getKieMiningFields() {
        return this.source.getKieMiningFields();
    }

    public List<OutputField> getKieOutputFields() {
        return this.source.getKieOutputFields();
    }

    public void addFields(List<Field<?>> toAdd) {
        if (toAdd != null) {
            toAdd.forEach(field -> {
                this.fields.removeIf(e -> e.getClass().equals(field.getClass()) && e.getName().equals((Object)field.getName()));
                this.fields.add((Field<?>)field);
            });
        }
    }

    protected CompilationDTO<T> getSource() {
        return this.source;
    }

    public List<KiePMMLMiningField> getKiePMMLMiningFields() {
        if (this.kiePMMLMiningFields == null) {
            this.kiePMMLMiningFields = this.getMiningSchema() != null && this.getMiningSchema().hasMiningFields() ? this.getMiningSchema().getMiningFields().stream().map(this::getKiePMMLMiningField).collect(Collectors.toList()) : Collections.emptyList();
        }
        return Collections.unmodifiableList(this.kiePMMLMiningFields);
    }

    public List<KiePMMLOutputField> getKiePMMLOutputFields() {
        if (this.kiePMMLOutputFields == null) {
            this.kiePMMLOutputFields = this.getOutput() != null && this.getOutput().hasOutputFields() ? this.getOutput().getOutputFields().stream().map(this::getKiePMMLOutputField).collect(Collectors.toList()) : Collections.emptyList();
        }
        return Collections.unmodifiableList(this.kiePMMLOutputFields);
    }

    public List<KiePMMLTarget> getKiePMMLTargetFields() {
        if (this.kiePMMLTargets == null) {
            this.kiePMMLTargets = this.getTargets() != null && this.getTargets().hasTargets() ? this.getTargets().getTargets().stream().map(this::getKiePMMLTarget).collect(Collectors.toList()) : Collections.emptyList();
        }
        return Collections.unmodifiableList(this.kiePMMLTargets);
    }

    public KiePMMLTransformationDictionary getKiePMMLTransformationDictionary() {
        if (this.kiePMMLTransformationDictionary == null && this.getTransformationDictionary() != null) {
            this.kiePMMLTransformationDictionary = this.getKiePMMLTransformationDictionary(this.getTransformationDictionary());
        }
        return this.kiePMMLTransformationDictionary;
    }

    public KiePMMLLocalTransformations getKiePMMLLocalTransformations() {
        if (this.kiePMMLLocalTransformations == null && this.getLocalTransformations() != null) {
            this.kiePMMLLocalTransformations = this.getKiePMMLLocalTransformations(this.getLocalTransformations());
        }
        return this.kiePMMLLocalTransformations;
    }

    private KiePMMLMiningField getKiePMMLMiningField(org.dmg.pmml.MiningField source) {
        Field field = this.fields.stream().filter(fld -> fld.getName().equals((Object)source.getName())).findFirst().orElseThrow(() -> new KiePMMLException("Cannot find " + source.getName() + " in DataDictionary"));
        return KiePMMLMiningFieldInstanceFactory.getKiePMMLMiningField(source, field);
    }

    private KiePMMLOutputField getKiePMMLOutputField(org.dmg.pmml.OutputField source) {
        return KiePMMLOutputFieldInstanceFactory.getKiePMMLOutputField(source);
    }

    private KiePMMLTarget getKiePMMLTarget(Target source) {
        return KiePMMLTargetInstanceFactory.getKiePMMLTarget(source);
    }

    private KiePMMLTransformationDictionary getKiePMMLTransformationDictionary(TransformationDictionary source) {
        return KiePMMLTransformationDictionaryInstanceFactory.getKiePMMLTransformationDictionary(source, this.getFields());
    }

    private KiePMMLLocalTransformations getKiePMMLLocalTransformations(LocalTransformations source) {
        return KiePMMLLocalTransformationsInstanceFactory.getKiePMMLLocalTransformations(source, this.getFields());
    }
}

