/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.Field;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.compiler.commons.factories.KiePMMLCompoundPredicateInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLFalsePredicateInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLSimplePredicateInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLSimpleSetPredicateInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLTruePredicateInstanceFactory;

public class KiePMMLPredicateInstanceFactory {
    private static final String PREDICATE_NOT_MANAGED = "Predicate %s not managed";

    private KiePMMLPredicateInstanceFactory() {
    }

    public static List<KiePMMLPredicate> getKiePMMLPredicates(List<Predicate> predicates, List<Field<?>> fields) {
        return predicates.stream().map(predicate -> KiePMMLPredicateInstanceFactory.getKiePMMLPredicate(predicate, fields)).collect(Collectors.toList());
    }

    static KiePMMLPredicate getKiePMMLPredicate(Predicate predicate, List<Field<?>> fields) {
        if (predicate instanceof SimplePredicate) {
            return KiePMMLSimplePredicateInstanceFactory.getKiePMMLSimplePredicate((SimplePredicate)predicate, fields);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return KiePMMLSimpleSetPredicateInstanceFactory.getKiePMMLSimpleSetPredicate((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof CompoundPredicate) {
            return KiePMMLCompoundPredicateInstanceFactory.getKiePMMLCompoundPredicate((CompoundPredicate)predicate, fields);
        }
        if (predicate instanceof True) {
            return KiePMMLTruePredicateInstanceFactory.getKiePMMLTruePredicate((True)predicate);
        }
        if (predicate instanceof False) {
            return KiePMMLFalsePredicateInstanceFactory.getKiePMMLFalsePredicate((False)predicate);
        }
        throw new IllegalArgumentException(String.format(PREDICATE_NOT_MANAGED, predicate.getClass()));
    }
}

