/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataField;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.factories.InstanceFactoriesTestCommon;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateInstanceFactory;

public class KiePMMLPredicateInstanceFactoryTest {
    @Test
    void getKiePMMLPredicate() {
        List fields = IntStream.range(0, 3).mapToObj(i -> PMMLModelTestUtils.getRandomDataField()).collect(Collectors.toList());
        SimplePredicate simplePredicate1 = PMMLModelTestUtils.getRandomSimplePredicate((DataField)((DataField)fields.get(0)));
        KiePMMLPredicate retrieved = KiePMMLPredicateInstanceFactory.getKiePMMLPredicate((Predicate)simplePredicate1, fields);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate(retrieved, (Predicate)simplePredicate1);
        SimpleSetPredicate simpleSetPredicate = PMMLModelTestUtils.getRandomSimpleSetPredicate((DataField)((DataField)fields.get(2)));
        retrieved = KiePMMLPredicateInstanceFactory.getKiePMMLPredicate((Predicate)simpleSetPredicate, fields);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate(retrieved, (Predicate)simpleSetPredicate);
        CompoundPredicate compoundPredicate = PMMLModelTestUtils.getRandomCompoundPredicate(fields);
        retrieved = KiePMMLPredicateInstanceFactory.getKiePMMLPredicate((Predicate)compoundPredicate, fields);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate(retrieved, (Predicate)compoundPredicate);
        False falsePredicate = new False();
        retrieved = KiePMMLPredicateInstanceFactory.getKiePMMLPredicate((Predicate)falsePredicate, fields);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate(retrieved, (Predicate)falsePredicate);
        True truePredicate = new True();
        retrieved = KiePMMLPredicateInstanceFactory.getKiePMMLPredicate((Predicate)truePredicate, fields);
        InstanceFactoriesTestCommon.commonVerifyKiePMMLPredicate(retrieved, (Predicate)truePredicate);
    }
}

