/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.ResourceTypePackageRegistry;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.api.pmml.PMMLConstants;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.evaluator.api.container.PMMLPackage;
import org.kie.pmml.evaluator.assembler.container.PMMLPackageImpl;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;
import org.kie.pmml.evaluator.assembler.service.PMMLLoaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLAssemblerService
implements KieAssemblerService {
    public static final String PMML_COMPILER_CACHE_KEY = "PMML_COMPILER_CACHE_KEY";
    private static final Logger logger = LoggerFactory.getLogger(PMMLAssemblerService.class);

    private static boolean isBuildFromMaven() {
        String property = System.getProperty("kie-maven-plugin-launcher", "false");
        return property.equals("true");
    }

    private static boolean isOtherImplementationPresent() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.kie.pmml.assembler.PMMLAssemblerService");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean isToEnable() {
        if (PMMLAssemblerService.isjPMMLAvailableToClassLoader()) {
            return false;
        }
        if (!PMMLAssemblerService.isOtherImplementationPresent()) {
            return true;
        }
        String property = System.getProperty(PMMLConstants.KIE_PMML_IMPLEMENTATION.getName(), PMMLConstants.LEGACY.getName());
        return property.equals(PMMLConstants.NEW.getName());
    }

    private static boolean isjPMMLAvailableToClassLoader() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.kie.dmn.jpmml.DMNjPMMLInvocationEvaluator");
            logger.info("jpmml libraries available on classpath, skipping kie-pmml parsing and compilation");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String[] getFactoryClassNamePackageName(Resource resource) {
        String sourcePath = resource.getSourcePath();
        String fileName = sourcePath.substring(sourcePath.lastIndexOf(47) + 1);
        fileName = fileName.replace(".pmml", "");
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)fileName);
        String factoryClassName = KiePMMLModelUtils.getSanitizedClassName((String)(fileName + "Factory"));
        return new String[]{factoryClassName, packageName};
    }

    public ResourceType getResourceType() {
        return PMMLAssemblerService.isToEnable() ? ResourceType.PMML : ResourceType.NOOP;
    }

    public void addResources(Object kbuilder, Collection<ResourceWithConfiguration> resources, ResourceType type) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        if (PMMLAssemblerService.isBuildFromMaven()) {
            this.addModels(kbuilderImpl, PMMLCompilerService.getKiePMMLModelsFromResourcesWithConfigurationsFromPlugin(kbuilderImpl, resources));
        } else {
            List<KiePMMLModel> toAdd = PMMLLoaderService.getKiePMMLModelsLoadedFromResourcesWithConfigurations(kbuilderImpl, resources);
            if (toAdd.isEmpty()) {
                toAdd = PMMLCompilerService.getKiePMMLModelsCompiledFromResourcesWithConfigurations(kbuilderImpl, resources);
            }
            this.addModels(kbuilderImpl, toAdd);
        }
    }

    public void addResource(Object kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) {
        logger.warn("invoked legacy addResource (no control on the order of the assembler compilation): {}", (Object)resource.getSourcePath());
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        if (PMMLAssemblerService.isBuildFromMaven()) {
            this.addModels(kbuilderImpl, PMMLCompilerService.getKiePMMLModelsFromResourceFromPlugin(kbuilderImpl, resource));
        } else {
            List<KiePMMLModel> toAdd = PMMLLoaderService.getKiePMMLModelsLoadedFromResource(kbuilderImpl, resource);
            if (toAdd.isEmpty()) {
                toAdd = PMMLCompilerService.getKiePMMLModelsCompiledFromResource(kbuilderImpl, resource);
            }
            this.addModels(kbuilderImpl, toAdd);
        }
    }

    protected void addModels(KnowledgeBuilderImpl kbuilderImpl, List<KiePMMLModel> toAdd) {
        for (KiePMMLModel kiePMMLModel : toAdd) {
            PackageDescr pkgDescr = new PackageDescr(kiePMMLModel.getKModulePackageName());
            PackageRegistry pkgReg = kbuilderImpl.getOrCreatePackageRegistry(pkgDescr);
            InternalKnowledgePackage kpkgs = pkgReg.getPackage();
            ResourceTypePackageRegistry rpkg = kpkgs.getResourceTypePackages();
            PMMLPackage pmmlPkg = (PMMLPackage)rpkg.computeIfAbsent(ResourceType.PMML, rtp -> new PMMLPackageImpl());
            pmmlPkg.addAll(Collections.singletonList(kiePMMLModel));
            if (!(kiePMMLModel instanceof HasNestedModels)) continue;
            this.addModels(kbuilderImpl, ((HasNestedModels)kiePMMLModel).getNestedModels());
        }
    }
}

