/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.pmml.commons.exceptions.ExternalException;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.kie.pmml.compiler.executor.PMMLCompilerImpl;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;

public class PMMLCompilerService {
    private PMMLCompilerService() {
    }

    public static List<KiePMMLModel> getKiePMMLModelsFromResourcesWithConfigurationsFromPlugin(KnowledgeBuilderImpl kbuilderImpl, Collection<ResourceWithConfiguration> resourceWithConfigurations) {
        return resourceWithConfigurations.stream().map(ResourceWithConfiguration::getResource).flatMap(resource -> PMMLCompilerService.getKiePMMLModelsFromResourceFromPlugin(kbuilderImpl, resource).stream()).collect(Collectors.toList());
    }

    public static List<KiePMMLModel> getKiePMMLModelsCompiledFromResourcesWithConfigurations(KnowledgeBuilderImpl kbuilderImpl, Collection<ResourceWithConfiguration> resourceWithConfigurations) {
        return resourceWithConfigurations.stream().map(ResourceWithConfiguration::getResource).flatMap(resource -> PMMLCompilerService.getKiePMMLModelsCompiledFromResource(kbuilderImpl, resource).stream()).collect(Collectors.toList());
    }

    public static List<KiePMMLModel> getKiePMMLModelsCompiledFromResource(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        PMMLCompiler pmmlCompiler = (PMMLCompiler)kbuilderImpl.getCachedOrCreate("PMML_COMPILER_CACHE_KEY", () -> PMMLCompilerService.getCompiler(kbuilderImpl));
        try {
            return pmmlCompiler.getModels(resource.getInputStream(), PMMLCompilerService.getFileName(resource.getSourcePath()), (Object)kbuilderImpl);
        }
        catch (IOException e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    public static List<KiePMMLModel> getKiePMMLModelsFromResourceFromPlugin(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        PMMLCompiler pmmlCompiler = (PMMLCompiler)kbuilderImpl.getCachedOrCreate("PMML_COMPILER_CACHE_KEY", () -> PMMLCompilerService.getCompiler(kbuilderImpl));
        String[] classNamePackageName = PMMLAssemblerService.getFactoryClassNamePackageName(resource);
        String factoryClassName = classNamePackageName[0];
        String packageName = classNamePackageName[1];
        try {
            return pmmlCompiler.getModelsFromPlugin(factoryClassName, packageName, resource.getInputStream(), PMMLCompilerService.getFileName(resource.getSourcePath()), (Object)kbuilderImpl);
        }
        catch (IOException e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    static PMMLCompiler getCompiler(KnowledgeBuilderImpl kbuilderImpl) {
        return new PMMLCompilerImpl();
    }

    static String getFileName(String fullPath) {
        String toReturn = fullPath;
        if (fullPath.contains(File.separator)) {
            toReturn = fullPath.substring(fullPath.lastIndexOf(File.separator) + 1);
        } else if (fullPath.contains("/")) {
            toReturn = fullPath.substring(fullPath.lastIndexOf(47) + 1);
        }
        return toReturn;
    }
}

