/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.commons.factories.KiePMMLModelFactory;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLLoaderService {
    private static final Logger logger = LoggerFactory.getLogger(PMMLLoaderService.class);

    public static List<KiePMMLModel> getKiePMMLModelsLoadedFromResourcesWithConfigurations(KnowledgeBuilderImpl kbuilderImpl, Collection<ResourceWithConfiguration> resourceWithConfigurations) {
        return resourceWithConfigurations.stream().map(ResourceWithConfiguration::getResource).flatMap(resource -> PMMLLoaderService.getKiePMMLModelsLoadedFromResource(kbuilderImpl, resource).stream()).collect(Collectors.toList());
    }

    public static List<KiePMMLModel> getKiePMMLModelsLoadedFromResource(KnowledgeBuilderImpl kbuilderImpl, Resource resource) {
        String[] classNamePackageName = PMMLAssemblerService.getFactoryClassNamePackageName(resource);
        String factoryClassName = classNamePackageName[0];
        String packageName = classNamePackageName[1];
        String fullFactoryClassName = packageName + "." + factoryClassName;
        try {
            Class<?> aClass = kbuilderImpl.getRootClassLoader().loadClass(fullFactoryClassName);
            return ((KiePMMLModelFactory)aClass.newInstance()).getKiePMMLModels();
        }
        catch (ClassNotFoundException e) {
            logger.info(String.format("%s class not found in rootClassLoader, going to compile model", fullFactoryClassName));
        }
        catch (Exception e) {
            throw new KiePMMLException("Exception while instantiating " + fullFactoryClassName, (Throwable)e);
        }
        return Collections.emptyList();
    }
}

