/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import java.io.File;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.FileSystemResource;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRuntimeFactory {
    private static final Logger logger = LoggerFactory.getLogger(PMMLRuntimeFactory.class);

    private PMMLRuntimeFactory() {
    }

    public static PMMLRuntime getPMMLRuntime(String kbaseName, File pmmlFile) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        return PMMLRuntimeFactory.getPMMLRuntime(kbaseName, pmmlFile, kbuilderImpl);
    }

    public static PMMLRuntime getPMMLRuntime(String kbaseName, File pmmlFile, ReleaseId releaseId) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilderImpl.setReleaseId(releaseId);
        return PMMLRuntimeFactory.getPMMLRuntime(kbaseName, pmmlFile, kbuilderImpl);
    }

    private static PMMLRuntime getPMMLRuntime(String kbaseName, File pmmlFile, KnowledgeBuilderImpl kbuilderImpl) {
        FileSystemResource fileSystemResource = new FileSystemResource(pmmlFile);
        new PMMLAssemblerService().addResource(kbuilderImpl, (Resource)fileSystemResource, ResourceType.PMML, null);
        InternalKnowledgeBase kieBase = KnowledgeBaseFactory.newKnowledgeBase((String)kbaseName, (KieBaseConfiguration)new RuleBaseConfiguration());
        kieBase.addPackages(kbuilderImpl.getKnowledgePackages());
        return PMMLRuntimeFactory.getPMMLRuntime((KieBase)kieBase);
    }

    private static PMMLRuntime getPMMLRuntime(KieBase kieBase) {
        KieRuntimeFactory kieRuntimeFactory = KieRuntimeFactory.of((KieBase)kieBase);
        return (PMMLRuntime)kieRuntimeFactory.get(PMMLRuntime.class);
    }
}

