/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.executor;

import java.io.Serializable;
import java.util.Map;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.clustering.ClusteringModel;
import org.junit.Assert;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.testutils.TestUtils;
import org.kie.pmml.models.clustering.compiler.executor.ClusteringModelImplementationProvider;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModelWithSources;

public class ClusteringModelImplementationProviderTest {
    private static final String SOURCE_FILE = "SingleIrisKMeansClustering.pmml";
    private static final String PACKAGE_NAME = "singleiriskmeansclustering";
    private static final ClusteringModelImplementationProvider PROVIDER = new ClusteringModelImplementationProvider();

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.CLUSTERING_MODEL, (Object)PROVIDER.getPMMLModelType());
    }

    @Test
    public void getKiePMMLModel() throws Exception {
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_FILE);
        ClusteringModel model = ClusteringModelImplementationProviderTest.getModel(pmml);
        KiePMMLClusteringModel retrieved = PROVIDER.getKiePMMLModel(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), model, (HasClassLoader)new HasClassLoaderMock());
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof Serializable));
    }

    @Test
    public void getKiePMMLModelWithSources() throws Exception {
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_FILE);
        ClusteringModel model = ClusteringModelImplementationProviderTest.getModel(pmml);
        KiePMMLClusteringModel retrieved = PROVIDER.getKiePMMLModelWithSources(PACKAGE_NAME, pmml.getDataDictionary(), pmml.getTransformationDictionary(), model, (HasClassLoader)new HasClassLoaderMock());
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof KiePMMLClusteringModelWithSources));
        KiePMMLClusteringModelWithSources retrievedWithSources = (KiePMMLClusteringModelWithSources)retrieved;
        Assert.assertTrue((boolean)(retrievedWithSources instanceof Serializable));
        Map sourcesMap = retrievedWithSources.getSourcesMap();
        Assert.assertNotNull((Object)sourcesMap);
        Assert.assertFalse((boolean)sourcesMap.isEmpty());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map compiled = KieMemoryCompiler.compile((Map)sourcesMap, (ClassLoader)classLoader);
        for (Class clazz : compiled.values()) {
            Assert.assertTrue((boolean)(clazz instanceof Serializable));
        }
    }

    private static ClusteringModel getModel(PMML pmml) {
        Assert.assertNotNull((Object)pmml);
        Assert.assertEquals((long)1L, (long)pmml.getModels().size());
        Model model = (Model)pmml.getModels().get(0);
        Assert.assertTrue((boolean)(model instanceof ClusteringModel));
        return (ClusteringModel)model;
    }
}

