/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.executor;

import java.io.Serializable;
import java.util.Map;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.clustering.ClusteringModel;
import org.junit.Assert;
import org.junit.Test;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.models.clustering.compiler.executor.ClusteringModelImplementationProvider;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;

public class ClusteringModelImplementationProviderTest {
    private static final String SOURCE_FILE = "SingleIrisKMeansClustering.pmml";
    private static final ClusteringModelImplementationProvider PROVIDER = new ClusteringModelImplementationProvider();

    private static ClusteringModel getModel(PMML pmml) {
        Assert.assertNotNull((Object)pmml);
        Assert.assertEquals((long)1L, (long)pmml.getModels().size());
        Model model = (Model)pmml.getModels().get(0);
        Assert.assertTrue((boolean)(model instanceof ClusteringModel));
        return (ClusteringModel)model;
    }

    @Test
    public void getPMMLModelType() {
        Assert.assertEquals((Object)PMML_MODEL.CLUSTERING_MODEL, (Object)PROVIDER.getPMMLModelType());
    }

    @Test
    public void getKiePMMLModel() throws Exception {
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_FILE);
        ClusteringModel model = ClusteringModelImplementationProviderTest.getModel(pmml);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLClusteringModel retrieved = PROVIDER.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof Serializable));
    }

    @Test
    public void getKiePMMLModelWithSources() throws Exception {
        PMML pmml = TestUtils.loadFromFile((String)SOURCE_FILE);
        ClusteringModel model = ClusteringModelImplementationProviderTest.getModel(pmml);
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        KiePMMLModelWithSources retrieved = PROVIDER.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assert.assertNotNull((Object)retrieved);
        Map sourcesMap = retrieved.getSourcesMap();
        Assert.assertNotNull((Object)sourcesMap);
        Assert.assertFalse((boolean)sourcesMap.isEmpty());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map compiled = KieMemoryCompiler.compile((Map)sourcesMap, (ClassLoader)classLoader);
        for (Class clazz : compiled.values()) {
            Assert.assertTrue((boolean)(clazz instanceof Serializable));
        }
    }
}

