/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLAgendaListenerUtils;
import org.kie.pmml.models.drools.utils.KiePMMLSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KiePMMLDroolsModel
extends KiePMMLModel {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLDroolsModel.class);
    private static final AgendaEventListener agendaEventListener = KiePMMLAgendaListenerUtils.getAgendaEventListener(logger);
    protected Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();

    protected KiePMMLDroolsModel(String modelName, List<KiePMMLExtension> extensions) {
        super(modelName, extensions);
    }

    public Map<String, KiePMMLOriginalTypeGeneratedType> getFieldTypeMap() {
        return this.fieldTypeMap;
    }

    public Object evaluate(Object knowledgeBase, Map<String, Object> requestData) {
        logger.trace("evaluate {} {}", knowledgeBase, requestData);
        if (!(knowledgeBase instanceof KieBase)) {
            throw new KiePMMLException(String.format("Expecting KieBase, received %s", knowledgeBase.getClass().getName()));
        }
        PMML4Result toReturn = this.getPMML4Result(this.targetField);
        String fullClassName = ((Object)((Object)this)).getClass().getName();
        String packageName = fullClassName.contains(".") ? fullClassName.substring(0, fullClassName.lastIndexOf(46)) : "";
        KiePMMLSessionUtils.Builder builder = KiePMMLSessionUtils.builder((KieBase)knowledgeBase, this.name, packageName, toReturn).withObjectsInSession(requestData, this.fieldTypeMap).withOutputFieldsMap(this.outputFieldsMap);
        if (logger.isDebugEnabled()) {
            builder = builder.withAgendaEventListener(agendaEventListener);
        }
        KiePMMLSessionUtils kiePMMLSessionUtils = builder.build();
        kiePMMLSessionUtils.fireAllRules();
        return toReturn;
    }

    public String getKModulePackageName() {
        return KiePMMLModelUtils.getSanitizedPackageName((String)this.name);
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLDroolsModel.class.getSimpleName() + "[", "]").add("kiePMMLOutputFields=" + this.kiePMMLOutputFields).add("fieldTypeMap=" + this.fieldTypeMap).add("pmmlMODEL=" + this.pmmlMODEL).add("miningFunction=" + this.miningFunction).add("targetField='" + this.targetField + "'").add("outputFieldsMap=" + this.outputFieldsMap).add("missingValueReplacementMap=" + this.missingValueReplacementMap).add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KiePMMLDroolsModel that = (KiePMMLDroolsModel)((Object)o);
        return Objects.equals(this.kiePMMLOutputFields, that.kiePMMLOutputFields) && Objects.equals(this.fieldTypeMap, that.fieldTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.kiePMMLOutputFields, this.fieldTypeMap);
    }

    private PMML4Result getPMML4Result(String targetField) {
        PMML4Result toReturn = new PMML4Result();
        toReturn.setResultCode(ResultCode.FAIL.getName());
        toReturn.setResultObjectName(targetField);
        return toReturn;
    }

    public static abstract class Builder<T extends KiePMMLDroolsModel>
    extends KiePMMLModel.Builder<T> {
        protected Builder(String prefix, PMML_MODEL pmmlMODEL, MINING_FUNCTION miningFunction, Supplier<T> supplier) {
            super(prefix, pmmlMODEL, miningFunction, supplier);
        }

        public Builder<T> withFieldTypeMap(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
            ((KiePMMLDroolsModel)this.toBuild).fieldTypeMap = fieldTypeMap;
            return this;
        }

        public Builder<T> withOutputFields(List<KiePMMLOutputField> outputFields) {
            ((KiePMMLDroolsModel)this.toBuild).kiePMMLOutputFields = outputFields;
            return this;
        }
    }
}

