/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.DerivedField;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class KiePMMLDerivedFieldASTFactory {
    private final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;

    private KiePMMLDerivedFieldASTFactory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        this.fieldTypeMap = fieldTypeMap;
    }

    public static KiePMMLDerivedFieldASTFactory factory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        return new KiePMMLDerivedFieldASTFactory(fieldTypeMap);
    }

    public List<KiePMMLDroolsType> declareTypes(List<DerivedField> derivedFields) {
        return derivedFields.stream().map(this::declareType).collect(Collectors.toList());
    }

    public KiePMMLDroolsType declareType(DerivedField derivedField) {
        String generatedType = KiePMMLModelUtils.getSanitizedClassName((String)derivedField.getName().getValue().toUpperCase());
        String fieldName = derivedField.getName().getValue();
        String fieldType = derivedField.getDataType().value();
        this.fieldTypeMap.put(fieldName, new KiePMMLOriginalTypeGeneratedType(fieldType, generatedType));
        return new KiePMMLDroolsType(generatedType, DATA_TYPE.byName((String)fieldType).getMappedClass().getSimpleName());
    }
}

