/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.MiningModel;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.enums.MINING_FUNCTION;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLExtensionFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentationFactory;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLMiningModelFactory {
    static final String SEGMENTATIONNAME_TEMPLATE = "%s_Segmentation";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLMiningModelFactory.class.getName());
    static final String KIE_PMML_MINING_MODEL_TEMPLATE_JAVA = "KiePMMLMiningModelTemplate.tmpl";
    static final String KIE_PMML_MINING_MODEL_TEMPLATE = "KiePMMLMiningModelTemplate";

    private KiePMMLMiningModelFactory() {
    }

    public static KiePMMLMiningModel getKiePMMLMiningModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, MiningModel model, KnowledgeBuilder kBuilder) {
        logger.debug("getKiePMMLMiningModel {}", (Object)model);
        String name = model.getModelName();
        Optional targetFieldName = ModelUtils.getTargetFieldName((DataDictionary)dataDictionary, (Model)model);
        List extensions = KiePMMLExtensionFactory.getKiePMMLExtensions((List)model.getExtensions());
        return (KiePMMLMiningModel)KiePMMLMiningModel.builder((String)name, (List)extensions, (MINING_FUNCTION)MINING_FUNCTION.byName((String)model.getMiningFunction().value())).withAlgorithmName(model.getAlgorithmName()).withScorable(model.isScorable()).withSegmentation(KiePMMLSegmentationFactory.getSegmentation(dataDictionary, transformationDictionary, model.getSegmentation(), String.format(SEGMENTATIONNAME_TEMPLATE, model.getModelName()), kBuilder)).withTargetField((String)targetFieldName.orElse(null)).build();
    }

    public static Map<String, String> getKiePMMLMiningModelSourcesMap(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, MiningModel model, String parentPackageName, KnowledgeBuilder kBuilder) {
        logger.trace("getKiePMMLMiningModelSourcesMap {} {} {}", new Object[]{dataDictionary, model, parentPackageName});
        String segmentationName = String.format(SEGMENTATIONNAME_TEMPLATE, model.getModelName());
        Map<String, String> toReturn = KiePMMLSegmentationFactory.getSegmentationSourcesMap(parentPackageName, dataDictionary, transformationDictionary, model.getSegmentation(), segmentationName, kBuilder);
        String segmentationClass = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segmentationName)) + "." + KiePMMLModelUtils.getSanitizedClassName((String)segmentationName);
        if (!toReturn.containsKey(segmentationClass)) {
            throw new KiePMMLException("Expected generated class " + segmentationClass + " not found");
        }
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)parentPackageName, (String)KIE_PMML_MINING_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_MINING_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        String modelName = model.getModelName();
        String targetFieldName = ModelUtils.getTargetFieldName((DataDictionary)dataDictionary, (Model)model).orElse(null);
        List outputFields = KiePMMLOutputFieldFactory.getOutputFields((Model)model);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        KiePMMLMiningModelFactory.setConstructor(className, constructorDeclaration, targetFieldName, MINING_FUNCTION.byName((String)model.getMiningFunction().value()), modelName, segmentationClass);
        KiePMMLModelFactoryUtils.addOutputFieldsPopulation((BlockStmt)constructorDeclaration.getBody(), (List)outputFields);
        KiePMMLModelFactoryUtils.addTransformationsInClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)modelTemplate, (TransformationDictionary)transformationDictionary, (LocalTransformations)model.getLocalTransformations());
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(String generatedClassName, ConstructorDeclaration constructorDeclaration, String targetField, MINING_FUNCTION miningFunction, String modelName, String segmentationClass) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)modelName);
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"targetField", (Expression)new StringLiteralExpr(targetField));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"miningFunction", (Expression)new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"pmmlMODEL", (Expression)new NameExpr(PMML_MODEL.MINING_MODEL.getClass().getName() + "." + PMML_MODEL.MINING_MODEL.name()));
        ClassOrInterfaceType kiePMMLSegmentationClass = StaticJavaParser.parseClassOrInterfaceType((String)segmentationClass);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentationClass);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"segmentation", (Expression)objectCreationExpr);
    }
}

