/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.Segment;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLExtensionFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSegmentFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSegmentFactory.class.getName());
    static final String KIE_PMML_SEGMENT_TEMPLATE_JAVA = "KiePMMLSegmentTemplate.tmpl";
    static final String KIE_PMML_SEGMENT_TEMPLATE = "KiePMMLSegmentTemplate";
    private static final String GET_SEGMENTS = "getSegments {}";
    private static final String GET_SEGMENT = "getSegment {}";

    private KiePMMLSegmentFactory() {
    }

    public static List<KiePMMLSegment> getSegments(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, List<Segment> segments, KnowledgeBuilder kBuilder) {
        logger.debug(GET_SEGMENTS, segments);
        return segments.stream().map(segment -> KiePMMLSegmentFactory.getSegment(dataDictionary, transformationDictionary, segment, kBuilder)).collect(Collectors.toList());
    }

    public static KiePMMLSegment getSegment(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Segment segment, KnowledgeBuilder kBuilder) {
        logger.debug(GET_SEGMENT, (Object)segment);
        return (KiePMMLSegment)KiePMMLSegment.builder((String)segment.getId(), (List)KiePMMLExtensionFactory.getKiePMMLExtensions((List)segment.getExtensions()), (KiePMMLPredicate)KiePMMLPredicateFactory.getPredicate((Predicate)segment.getPredicate(), (DataDictionary)dataDictionary), (KiePMMLModel)((KiePMMLModel)KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((DataDictionary)dataDictionary, (TransformationDictionary)transformationDictionary, (Model)segment.getModel(), (Object)kBuilder).orElseThrow(() -> new KiePMMLException("Failed to get the KiePMMLModel for segment " + segment.getModel().getModelName())))).withWeight(segment.getWeight().doubleValue()).build();
    }

    public static Map<String, String> getSegmentsSourcesMap(String parentPackageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, List<Segment> segments, KnowledgeBuilder kBuilder) {
        logger.debug(GET_SEGMENTS, segments);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        segments.forEach(segment -> toReturn.putAll(KiePMMLSegmentFactory.getSegmentSourcesMap(parentPackageName, dataDictionary, transformationDictionary, segment, kBuilder)));
        return toReturn;
    }

    public static Map<String, String> getSegmentSourcesMap(String parentPackageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Segment segment, KnowledgeBuilder kBuilder) {
        logger.debug(GET_SEGMENT, (Object)segment);
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segment.getId()));
        KiePMMLModel kiePmmlModel = (KiePMMLModel)KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelFromPlugin((String)packageName, (DataDictionary)dataDictionary, (TransformationDictionary)transformationDictionary, (Model)segment.getModel(), (Object)kBuilder).orElseThrow(() -> new KiePMMLException("Failed to get the KiePMMLModel for segment " + segment.getModel().getModelName()));
        return KiePMMLSegmentFactory.getSegmentSourcesMap(packageName, dataDictionary, segment, kiePmmlModel);
    }

    public static Map<String, String> getSegmentSourcesMap(String packageName, DataDictionary dataDictionary, Segment segment, KiePMMLModel kiePmmlModel) {
        String kiePMMLModelClass;
        logger.debug(GET_SEGMENT, (Object)segment);
        if (!(kiePmmlModel instanceof HasSourcesMap)) {
            throw new KiePMMLException("Retrieved KiePMMLModel for segment " + segment.getModel().getModelName() + " does not implement HasSources");
        }
        HashMap<String, String> toReturn = new HashMap<String, String>(((HasSourcesMap)kiePmmlModel).getSourcesMap());
        if (!toReturn.containsKey(kiePMMLModelClass = packageName + "." + KiePMMLModelUtils.getSanitizedClassName((String)segment.getModel().getModelName()))) {
            throw new KiePMMLException("Expected generated class " + kiePMMLModelClass + " not found");
        }
        String className = KiePMMLModelUtils.getSanitizedClassName((String)segment.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_SEGMENT_TEMPLATE_JAVA, (String)KIE_PMML_SEGMENT_TEMPLATE);
        ClassOrInterfaceDeclaration segmentTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)segmentTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", segmentTemplate.getName())));
        KiePMMLPredicate predicate = KiePMMLPredicateFactory.getPredicate((Predicate)segment.getPredicate(), (DataDictionary)dataDictionary);
        toReturn.putAll(KiePMMLPredicateFactory.getPredicateSourcesMap((KiePMMLPredicate)predicate, (String)packageName));
        String predicateClassName = packageName + "." + KiePMMLModelUtils.getSanitizedClassName((String)predicate.getId());
        KiePMMLSegmentFactory.setConstructor(segment.getId(), className, constructorDeclaration, predicateClassName, kiePMMLModelClass, segment.getWeight().doubleValue());
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(String segmentName, String generatedClassName, ConstructorDeclaration constructorDeclaration, String predicateClassName, String kiePMMLModelClass, double weight) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)segmentName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)predicateClassName);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        CommonCodegenUtils.setExplicitConstructorInvocationArgument((ExplicitConstructorInvocationStmt)superStatement, (String)"kiePMMLPredicate", (String)objectCreationExpr.toString());
        classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)kiePMMLModelClass);
        objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        CommonCodegenUtils.setExplicitConstructorInvocationArgument((ExplicitConstructorInvocationStmt)superStatement, (String)"model", (String)objectCreationExpr.toString());
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"weight", (Expression)new DoubleLiteralExpr(weight));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"id", (Expression)new StringLiteralExpr(segmentName));
    }
}

