/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleUnaryOperator;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.OP_TYPE;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.kie.pmml.models.regression.model.enums.REGRESSION_NORMALIZATION_METHOD;

public abstract class KiePMMLRegressionClassificationTable
extends KiePMMLRegressionTable {
    protected REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod;
    protected OP_TYPE opType;
    protected List<KiePMMLOutputField> outputFields = new ArrayList<KiePMMLOutputField>();
    protected Map<String, Object> outputFieldsMap = new HashMap<String, Object>();
    protected Map<String, KiePMMLRegressionTable> categoryTableMap = new HashMap<String, KiePMMLRegressionTable>();

    @Override
    public Object evaluateRegression(Map<String, Object> input) {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, KiePMMLRegressionTable> entry : this.categoryTableMap.entrySet()) {
            resultMap.put(entry.getKey(), (Double)entry.getValue().evaluateRegression(input));
        }
        LinkedHashMap<String, Double> probabilityMap = this.getProbabilityMap(resultMap);
        Map.Entry<String, Double> predictedEntry = Collections.max(probabilityMap.entrySet(), Map.Entry.comparingByValue());
        probabilityMap.put(this.targetField, (Double)predictedEntry.getValue());
        this.populateOutputFieldsMap(predictedEntry, probabilityMap);
        this.outputFieldsMap.put(this.targetField, predictedEntry.getKey());
        return predictedEntry.getKey();
    }

    public abstract boolean isBinary();

    protected abstract LinkedHashMap<String, Double> getProbabilityMap(LinkedHashMap<String, Double> var1);

    protected abstract void populateOutputFieldsMap(Map.Entry<String, Double> var1, LinkedHashMap<String, Double> var2);

    @Override
    protected void updateResult(AtomicReference<Double> toUpdate) {
    }

    @Override
    public Map<String, Object> getOutputFieldsMap() {
        return this.outputFieldsMap;
    }

    public REGRESSION_NORMALIZATION_METHOD getRegressionNormalizationMethod() {
        return this.regressionNormalizationMethod;
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public Map<String, KiePMMLRegressionTable> getCategoryTableMap() {
        return this.categoryTableMap;
    }

    protected LinkedHashMap<String, Double> getProbabilityMap(LinkedHashMap<String, Double> resultMap, DoubleUnaryOperator firstItemOperator, DoubleUnaryOperator secondItemOperator) {
        if (resultMap.size() != 2) {
            throw new KiePMMLException(String.format("Expected two entries, retrieved %d", resultMap.size()));
        }
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = resultMap.keySet().toArray(new String[0]);
        double firstItem = firstItemOperator.applyAsDouble(resultMap.get(resultMapKeys[0]));
        double secondItem = secondItemOperator.applyAsDouble(firstItem);
        toReturn.put(resultMapKeys[0], firstItem);
        toReturn.put(resultMapKeys[1], secondItem);
        return toReturn;
    }
}

