/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public abstract class KiePMMLRegressionTable {
    protected Map<String, Function<Double, Double>> numericFunctionMap = new HashMap<String, Function<Double, Double>>();
    protected Map<String, Function<Object, Double>> categoricalFunctionMap = new HashMap<String, Function<Object, Double>>();
    protected Map<String, Object> outputFieldsMap = new HashMap<String, Object>();
    protected Map<String, Function<Map<String, Object>, Double>> predictorTermsFunctionMap = new HashMap<String, Function<Map<String, Object>, Double>>();
    protected double intercept;
    protected String targetField;

    public abstract Object getTargetCategory();

    public Object evaluateRegression(Map<String, Object> input) {
        String key;
        AtomicReference<Double> result = new AtomicReference<Double>(this.intercept);
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (Map.Entry<String, Function<Double, Double>> entry : this.numericFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, entry.getValue().apply(((Number)input.get(key)).doubleValue()));
        }
        for (Map.Entry<String, Function<Object, Double>> entry : this.categoricalFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, entry.getValue().apply(input.get(key)));
        }
        for (Map.Entry<String, Function<Object, Double>> entry : this.predictorTermsFunctionMap.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().apply(input));
        }
        resultMap.values().forEach(value -> result.accumulateAndGet((Double)value, Double::sum));
        this.updateResult(result);
        Double toReturn = result.get();
        this.populateOutputFieldsMapWithResult(toReturn);
        return toReturn;
    }

    public Map<String, Object> getOutputFieldsMap() {
        return this.outputFieldsMap;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public Map<String, Function<Double, Double>> getNumericFunctionMap() {
        return this.numericFunctionMap;
    }

    public Map<String, Function<Object, Double>> getCategoricalFunctionMap() {
        return this.categoricalFunctionMap;
    }

    public Map<String, Function<Map<String, Object>, Double>> getPredictorTermsFunctionMap() {
        return this.predictorTermsFunctionMap;
    }

    public double getIntercept() {
        return this.intercept;
    }

    protected abstract void updateResult(AtomicReference<Double> var1);

    protected abstract void populateOutputFieldsMapWithResult(Object var1);
}

