/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;

public abstract class AbstractKiePMMLTable
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -7899446939844650691L;
    protected Map<String, SerializableFunction<Double, Double>> numericFunctionMap = new HashMap<String, SerializableFunction<Double, Double>>();
    protected Map<String, SerializableFunction<String, Double>> categoricalFunctionMap = new HashMap<String, SerializableFunction<String, Double>>();
    protected Map<String, SerializableFunction<Map<String, Object>, Double>> predictorTermsFunctionMap = new HashMap<String, SerializableFunction<Map<String, Object>, Double>>();
    protected SerializableFunction<Double, Double> resultUpdater;
    protected double intercept;
    protected String targetField;
    protected Object targetCategory;

    public Object getTargetCategory() {
        return this.targetCategory;
    }

    public Object evaluateRegression(Map<String, Object> input, PMMLRuntimeContext context) {
        String key;
        double result = this.intercept;
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (Map.Entry<String, SerializableFunction<Double, Double>> entry : this.numericFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, (Double)entry.getValue().apply((Object)((Number)input.get(key)).doubleValue()));
        }
        for (Map.Entry<String, Object> entry : this.categoricalFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, (Double)((SerializableFunction)entry.getValue()).apply((Object)input.get(key).toString()));
        }
        for (Map.Entry<String, Object> entry : this.predictorTermsFunctionMap.entrySet()) {
            resultMap.put(entry.getKey(), (Double)((SerializableFunction)entry.getValue()).apply(input));
        }
        for (Double d : resultMap.values()) {
            result += d.doubleValue();
        }
        if (this.resultUpdater != null) {
            result = (Double)this.resultUpdater.apply((Object)result);
        }
        return result;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public Map<String, SerializableFunction<Double, Double>> getNumericFunctionMap() {
        return this.numericFunctionMap;
    }

    public Map<String, SerializableFunction<String, Double>> getCategoricalFunctionMap() {
        return this.categoricalFunctionMap;
    }

    public Map<String, SerializableFunction<Map<String, Object>, Double>> getPredictorTermsFunctionMap() {
        return this.predictorTermsFunctionMap;
    }

    public double getIntercept() {
        return this.intercept;
    }

    protected AbstractKiePMMLTable(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static double evaluateNumericWithExponent(double input, double coefficient, double exponent) {
        return Math.pow(input, exponent) * coefficient;
    }

    public static double evaluateNumericWithoutExponent(double input, double coefficient) {
        return input * coefficient;
    }

    public static double evaluateCategoricalPredictor(Object input, Map<String, Double> valuesMap) {
        return valuesMap.getOrDefault(input.toString(), 0.0);
    }

    public static double updateSOFTMAXResult(Double y) {
        return 1.0 / (1.0 + Math.exp(-y.doubleValue()));
    }

    public static double updateLOGITResult(Double y) {
        return 1.0 / (1.0 + Math.exp(-y.doubleValue()));
    }

    public static double updateEXPResult(Double y) {
        return Math.exp(y);
    }

    public static double updatePROBITResult(Double y) {
        return new NormalDistribution().cumulativeProbability(y.doubleValue());
    }

    public static double updateCLOGLOGResult(Double y) {
        return 1.0 - Math.exp(-Math.exp(y));
    }

    public static double updateCAUCHITResult(Double y) {
        return 0.5 + 0.3183098861837907 * Math.atan(y);
    }

    public static double updateNONEResult(Double y) {
        return y;
    }

    public static class Builder<T extends AbstractKiePMMLTable>
    extends AbstractKiePMMLComponent.Builder<T> {
        protected Builder(String prefix, Supplier<T> supplier) {
            super(prefix, supplier);
        }

        public Builder<T> withNumericFunctionMap(Map<String, SerializableFunction<Double, Double>> numericFunctionMap) {
            if (numericFunctionMap != null) {
                ((AbstractKiePMMLTable)this.toBuild).numericFunctionMap.putAll(numericFunctionMap);
            }
            return this;
        }

        public Builder<T> withCategoricalFunctionMap(Map<String, SerializableFunction<String, Double>> categoricalFunctionMap) {
            if (categoricalFunctionMap != null) {
                ((AbstractKiePMMLTable)this.toBuild).categoricalFunctionMap.putAll(categoricalFunctionMap);
            }
            return this;
        }

        public Builder<T> withPredictorTermsFunctionMap(Map<String, SerializableFunction<Map<String, Object>, Double>> predictorTermsFunctionMap) {
            if (predictorTermsFunctionMap != null) {
                ((AbstractKiePMMLTable)this.toBuild).predictorTermsFunctionMap.putAll(predictorTermsFunctionMap);
            }
            return this;
        }

        public Builder<T> withResultUpdater(SerializableFunction<Double, Double> resultUpdater) {
            if (resultUpdater != null) {
                ((AbstractKiePMMLTable)this.toBuild).resultUpdater = resultUpdater;
            }
            return this;
        }

        public Builder<T> withIntercept(Double intercept) {
            if (intercept != null) {
                ((AbstractKiePMMLTable)this.toBuild).intercept = intercept;
            }
            return this;
        }

        public Builder<T> withTargetField(String targetField) {
            ((AbstractKiePMMLTable)this.toBuild).targetField = targetField;
            return this;
        }

        public Builder<T> withTargetCategory(Object targetCategory) {
            ((AbstractKiePMMLTable)this.toBuild).targetCategory = targetCategory;
            return this;
        }
    }
}

