/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.RemoteWorkingMemory;
import org.kie.remote.TopicsConfig;
import org.kie.remote.command.AbstractCommand;
import org.kie.remote.command.FactCountCommand;
import org.kie.remote.command.ListObjectsCommand;
import org.kie.remote.command.ListObjectsCommandClassType;
import org.kie.remote.command.ListObjectsCommandNamedQuery;
import org.kie.remote.impl.producer.Sender;

public abstract class AbstractRemoteEntryPoint
implements RemoteWorkingMemory {
    protected final Sender sender;
    protected final String entryPoint;
    protected TopicsConfig topicsConfig;

    public AbstractRemoteEntryPoint(Sender sender, String entryPoint, TopicsConfig topicsConfig) {
        this.sender = sender;
        this.entryPoint = entryPoint;
        this.topicsConfig = topicsConfig;
    }

    @Override
    public String getEntryPointId() {
        return this.entryPoint;
    }

    @Override
    public CompletableFuture<Collection<? extends Object>> getObjects() {
        ListObjectsCommand command = new ListObjectsCommand(this.entryPoint);
        return this.executeCommand(command);
    }

    @Override
    public <T> CompletableFuture<Collection<T>> getObjects(Class<T> clazztype) {
        ListObjectsCommandClassType command = new ListObjectsCommandClassType(this.entryPoint, clazztype);
        return this.executeCommand(command);
    }

    @Override
    public CompletableFuture<Collection<? extends Object>> getObjects(String namedQuery, String objectName, Object ... params) {
        ListObjectsCommandNamedQuery command = new ListObjectsCommandNamedQuery(this.entryPoint, namedQuery, objectName, params);
        return this.executeCommand(command);
    }

    @Override
    public CompletableFuture<Long> getFactCount() {
        FactCountCommand command = new FactCountCommand(this.entryPoint);
        return this.executeCommand(command);
    }

    protected <T> CompletableFuture<T> executeCommand(AbstractCommand command) {
        CompletableFuture callback = new CompletableFuture();
        this.getRequestsStore().put(command.getId(), callback);
        this.sender.sendCommand(command, this.topicsConfig.getEventsTopicName());
        return callback;
    }

    protected abstract Map<String, CompletableFuture<Object>> getRequestsStore();
}

