/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl.consumer;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.TopicsConfig;
import org.kie.remote.impl.consumer.ListenerThread;
import org.kie.remote.message.ResultMessage;
import org.kie.remote.util.LocalMessageSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalListenerThread
implements ListenerThread {
    private static Logger logger = LoggerFactory.getLogger(LocalListenerThread.class);
    private final LocalMessageSystem queue = LocalMessageSystem.get();
    private TopicsConfig topicsConfig;
    private Map<String, CompletableFuture<Object>> requestsStore;
    private volatile boolean running = true;

    public LocalListenerThread(TopicsConfig topicsConfig, Map<String, CompletableFuture<Object>> requestsStore) {
        this.topicsConfig = topicsConfig;
        this.requestsStore = requestsStore;
    }

    @Override
    public void run() {
        while (this.running) {
            Object msg = this.queue.poll(this.topicsConfig.getKieSessionInfosTopicName());
            if (msg instanceof ResultMessage) {
                this.complete(this.requestsStore, (ResultMessage)msg, logger);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }
}

