/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl.consumer;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.TopicsConfig;
import org.kie.remote.impl.ClientUtils;
import org.kie.remote.impl.consumer.KafkaListenerThread;
import org.kie.remote.impl.consumer.LocalListenerThread;
import org.kie.remote.message.ResultMessage;
import org.kie.remote.util.ConfigurationUtil;
import org.slf4j.Logger;

public interface ListenerThread
extends Runnable {
    public void stop();

    public static ListenerThread get(TopicsConfig topicsConfig, Map<String, CompletableFuture<Object>> requestsStore, Properties configuration) {
        return ListenerThread.get(topicsConfig, requestsStore, ConfigurationUtil.readBoolean(configuration, "local.message.system"));
    }

    public static ListenerThread get(TopicsConfig topicsConfig, Map<String, CompletableFuture<Object>> requestsStore, boolean isLocal) {
        return isLocal ? new LocalListenerThread(topicsConfig, requestsStore) : new KafkaListenerThread(ClientUtils.getConfiguration("consumer.properties"), topicsConfig, requestsStore);
    }

    default public void complete(Map<String, CompletableFuture<Object>> requestsStore, ResultMessage message, Logger logger) {
        CompletableFuture<Object> completableFuture = requestsStore.get(message.getId());
        if (completableFuture != null) {
            completableFuture.complete(message.getResult());
            if (logger.isDebugEnabled()) {
                logger.debug("completed msg with key {}", (Object)message.getId());
            }
        }
    }
}

