/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.RemoteStreamingEntryPoint;
import org.kie.remote.RemoteStreamingKieSession;
import org.kie.remote.TopicsConfig;
import org.kie.remote.impl.RemoteStreamingEntryPointImpl;
import org.kie.remote.impl.consumer.Listener;
import org.kie.remote.impl.producer.Sender;

public class RemoteStreamingKieSessionImpl
extends RemoteStreamingEntryPointImpl
implements RemoteStreamingKieSession {
    private final Map<String, RemoteStreamingEntryPoint> entryPoints = new HashMap<String, RemoteStreamingEntryPoint>();

    public RemoteStreamingKieSessionImpl(Properties configuration) {
        this(configuration, TopicsConfig.getDefaultTopicsConfig());
    }

    public RemoteStreamingKieSessionImpl(Properties configuration, TopicsConfig envConfig) {
        super(new Sender(configuration), "DEFAULT", envConfig, new Listener(configuration));
        this.sender.start();
        this.fireUntilHalt();
    }

    @Override
    public void close() {
        this.sender.stop();
        this.delegate.stop();
    }

    @Override
    public RemoteStreamingEntryPoint getEntryPoint(String name) {
        return this.entryPoints.computeIfAbsent(name, k -> new RemoteStreamingEntryPointImpl(this.sender, (String)k, this.topicsConfig, this.delegate));
    }

    @Override
    public CompletableFuture<Long> fireAllRules() {
        return this.delegate.fireAllRules();
    }

    @Override
    public void fireUntilHalt() {
        this.delegate.fireUntilHalt();
    }

    @Override
    public void halt() {
        this.delegate.halt();
    }
}

