/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.RemoteEntryPoint;
import org.kie.remote.RemoteKieSession;
import org.kie.remote.TopicsConfig;
import org.kie.remote.command.GetKJarGAVCommand;
import org.kie.remote.command.UpdateKJarCommand;
import org.kie.remote.impl.RemoteEntryPointImpl;
import org.kie.remote.impl.consumer.Listener;
import org.kie.remote.impl.producer.Sender;

public class RemoteKieSessionImpl
extends RemoteEntryPointImpl
implements RemoteKieSession {
    public static final String DEFAULT_ENTRY_POINT = "DEFAULT";
    private final Map<String, RemoteEntryPoint> entryPoints = new HashMap<String, RemoteEntryPoint>();

    public RemoteKieSessionImpl(Properties configuration) {
        this(configuration, TopicsConfig.getDefaultTopicsConfig());
    }

    public RemoteKieSessionImpl(Properties configuration, TopicsConfig envConfig) {
        super(new Sender(configuration), DEFAULT_ENTRY_POINT, envConfig, new Listener(configuration));
        this.sender.start();
    }

    @Override
    public void close() {
        this.sender.stop();
        this.delegate.stop();
    }

    @Override
    public RemoteEntryPoint getEntryPoint(String name) {
        return this.entryPoints.computeIfAbsent(name, k -> new RemoteEntryPointImpl(this.sender, (String)k, this.topicsConfig, this.delegate));
    }

    @Override
    public CompletableFuture<Long> fireAllRules() {
        return this.delegate.fireAllRules();
    }

    @Override
    public void fireUntilHalt() {
        this.delegate.fireUntilHalt();
    }

    @Override
    public void halt() {
        this.delegate.halt();
    }

    @Override
    public CompletableFuture<Boolean> updateKJarGAV(String kJar) {
        UpdateKJarCommand command = new UpdateKJarCommand(kJar);
        return this.executeCommand(command);
    }

    @Override
    public CompletableFuture<String> getKJarGAV() {
        GetKJarGAVCommand command = new GetKJarGAVCommand(this.entryPoint);
        return this.executeCommand(command);
    }
}

