/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.RemoteStreamingEntryPoint;
import org.kie.remote.RemoteStreamingKieSession;
import org.kie.remote.TopicsConfig;
import org.kie.remote.command.GetKJarGAVCommand;
import org.kie.remote.command.UpdateKJarCommand;
import org.kie.remote.impl.RemoteStreamingEntryPointImpl;
import org.kie.remote.impl.consumer.Listener;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.impl.producer.Sender;

public class RemoteStreamingKieSessionImpl
extends RemoteStreamingEntryPointImpl
implements RemoteStreamingKieSession {
    private final Map<String, RemoteStreamingEntryPoint> entryPoints = new HashMap<String, RemoteStreamingEntryPoint>();

    public RemoteStreamingKieSessionImpl(Properties configuration, Listener listener, Producer producer) {
        this(configuration, TopicsConfig.getDefaultTopicsConfig(), listener, producer);
    }

    public RemoteStreamingKieSessionImpl(Properties configuration, TopicsConfig envConfig, Listener listener, Producer producer) {
        super(new Sender(configuration, producer), "DEFAULT", envConfig, listener);
        this.sender.start();
        this.fireUntilHalt();
    }

    @Override
    public void close() {
        this.sender.stop();
        this.delegate.stop();
    }

    @Override
    public RemoteStreamingEntryPoint getEntryPoint(String name) {
        return this.entryPoints.computeIfAbsent(name, k -> new RemoteStreamingEntryPointImpl(this.sender, (String)k, this.topicsConfig, this.delegate));
    }

    @Override
    public CompletableFuture<Long> fireAllRules() {
        return this.delegate.fireAllRules();
    }

    @Override
    public void fireUntilHalt() {
        this.delegate.fireUntilHalt();
    }

    @Override
    public void halt() {
        this.delegate.halt();
    }

    @Override
    public CompletableFuture<Boolean> updateKJarGAV(String kJar) {
        UpdateKJarCommand command = new UpdateKJarCommand(kJar);
        return this.executeCommand(command);
    }

    @Override
    public CompletableFuture<String> getKJarGAV() {
        GetKJarGAVCommand command = new GetKJarGAVCommand(this.entryPoint);
        return this.executeCommand(command);
    }
}

