/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.drools;

import java.util.List;
import java.util.Optional;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.drools.DroolsKieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class DroolsKieServerAutoConfiguration {
    private KieServerProperties properties;

    public DroolsKieServerAutoConfiguration(KieServerProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"droolsServerExtension"})
    @ConditionalOnProperty(name={"kieserver.drools.enabled"})
    public KieServerExtension droolsServerExtension(final Optional<List<AgendaEventListener>> agendaEventListeners, final Optional<List<RuleRuntimeEventListener>> ruleRuntimeEventListeners) {
        return new DroolsKieServerExtension(){

            public void init(KieServerImpl kieServer, KieServerRegistry registry) {
                super.init(kieServer, registry);
                this.rulesExecutionService.setAgendaEventListeners((List)agendaEventListeners.orElse(null));
                this.rulesExecutionService.setRuleRuntimeEventListeners((List)ruleRuntimeEventListeners.orElse(null));
            }
        };
    }
}

