/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.jbpm;

import java.util.Optional;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceAdminService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.springboot.autoconfigure.JBPMAutoConfiguration;
import org.kie.api.executor.ExecutorService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.kie.server.springboot.autoconfiguration.jbpm.extensions.SpringBootJBPMKieServerExtension;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@AutoConfigureAfter(value={JBPMAutoConfiguration.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class JBPMKieServerAutoConfiguration {
    private KieServerProperties properties;
    private DeploymentService deploymentService;
    private DefinitionService definitionService;
    private ProcessService processService;
    private UserTaskService userTaskService;
    private RuntimeDataService runtimeDataService;
    private FormManagerService formManagerService;
    private ProcessInstanceMigrationService processInstanceMigrationService;
    private ProcessInstanceAdminService processInstanceAdminService;
    private UserTaskAdminService userTaskAdminService;
    private ExecutorService executorService;
    private QueryService queryService;

    public JBPMKieServerAutoConfiguration(KieServerProperties properties, DeploymentService deploymentService, DefinitionService definitionService, ProcessService processService, UserTaskService userTaskService, RuntimeDataService runtimeDataService, FormManagerService formManagerService, ProcessInstanceMigrationService processInstanceMigrationService, ProcessInstanceAdminService processInstanceAdminService, UserTaskAdminService userTaskAdminService, Optional<ExecutorService> executorService, QueryService queryService) {
        this.properties = properties;
        this.deploymentService = deploymentService;
        this.definitionService = definitionService;
        this.processService = processService;
        this.userTaskService = userTaskService;
        this.runtimeDataService = runtimeDataService;
        this.formManagerService = formManagerService;
        this.processInstanceMigrationService = processInstanceMigrationService;
        this.processInstanceAdminService = processInstanceAdminService;
        this.userTaskAdminService = userTaskAdminService;
        if (executorService.isPresent()) {
            this.executorService = executorService.get();
        }
        this.queryService = queryService;
    }

    @Bean
    @ConditionalOnMissingBean(name={"jBPMServerExtension"})
    @ConditionalOnProperty(name={"kieserver.jbpm.enabled"})
    public KieServerExtension jbpmServerExtension() {
        return new SpringBootJBPMKieServerExtension(this.deploymentService, this.definitionService, this.processService, this.userTaskService, this.runtimeDataService, this.formManagerService, this.processInstanceMigrationService, this.processInstanceAdminService, this.userTaskAdminService, this.executorService, this.queryService);
    }
}

