/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.jbpm;

import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.locator.ByCaseIdContainerLocator;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.jbpm.locator.ByTaskIdContainerLocator;
import org.kie.server.services.jbpm.locator.ProcessContainerLocatorProvider;

public class ContainerAliasResolver {
    private KieServerRegistry registry;

    public ContainerAliasResolver(KieServerRegistry registry) {
        this.registry = registry;
    }

    public String latest(String alias) {
        return this.registry.getContainerId(alias, ContainerLocatorProvider.get().getLocator());
    }

    public String forCaseInstance(String alias, String caseId) {
        return this.registry.getContainerId(alias, (ContainerLocator)new ByCaseIdContainerLocator(caseId));
    }

    public String forProcessInstance(String alias, long processInstanceId) {
        return this.registry.getContainerId(alias, ProcessContainerLocatorProvider.get().getLocator((Number)processInstanceId));
    }

    public String forTaskInstance(String alias, long taskId) {
        return this.registry.getContainerId(alias, (ContainerLocator)new ByTaskIdContainerLocator(Long.valueOf(taskId)));
    }
}

