/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.taskassigning;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.services.taskassigning.runtime.TaskAssigningRuntimeKieServerExtension;
import org.kie.server.springboot.autoconfiguration.taskassigning.TaskAssigningRuntimeKieServerAutoConfiguration;
import org.mockito.Mockito;
import org.springframework.context.event.ContextClosedEvent;

public class TaskAssigningRuntimeKieServerAutoConfigurationTest {
    private TaskAssigningRuntimeKieServerAutoConfiguration configuration;
    private static final String KIE_TASK_ASSIGNING_RUNTIME_EXT_DISABLED_PREVIOUS_VALUE = "KIE_TASK_ASSIGNING_RUNTIME_EXT_DISABLED_PREVIOUS_VALUE";

    @Before
    public void setUp() {
        this.configuration = new TaskAssigningRuntimeKieServerAutoConfiguration();
    }

    @After
    public void cleanUp() {
        System.clearProperty(KIE_TASK_ASSIGNING_RUNTIME_EXT_DISABLED_PREVIOUS_VALUE);
    }

    @Test
    public void taskAssigningRuntimeServerExtension() {
        System.setProperty("org.kie.server.taskAssigning.runtime.ext.disabled", KIE_TASK_ASSIGNING_RUNTIME_EXT_DISABLED_PREVIOUS_VALUE);
        TaskAssigningRuntimeKieServerExtension extension = (TaskAssigningRuntimeKieServerExtension)this.configuration.taskAssigningRuntimeServerExtension();
        Assert.assertTrue((boolean)extension.isActive());
        this.configuration.handleContextRefreshEvent((ContextClosedEvent)Mockito.mock(ContextClosedEvent.class));
        Assert.assertEquals((Object)KIE_TASK_ASSIGNING_RUNTIME_EXT_DISABLED_PREVIOUS_VALUE, (Object)System.getProperty("org.kie.server.taskAssigning.runtime.ext.disabled"));
    }

    @Test
    public void taskAssigningPersistenceUnitPostProcessor() {
        Assert.assertNotNull((Object)this.configuration.taskAssigningPersistenceUnitPostProcessor());
    }
}

