/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.taskassigning;

import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.taskassigning.runtime.TaskAssigningRuntimeKieServerExtension;
import org.kie.server.springboot.autoconfiguration.jbpm.JBPMKieServerAutoConfiguration;
import org.kie.server.springboot.autoconfiguration.taskassigning.TaskAssigningPersistenceUnitPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@AutoConfigureAfter(value={JBPMKieServerAutoConfiguration.class})
public class TaskAssigningRuntimeKieServerAutoConfiguration {
    private static final String KIE_SERVER_TASK_ASSIGNING_RUNTIME_ENABLED = "kieserver.taskAssigning.runtime.enabled";
    private String runtimeDisabledValue = null;

    @Bean
    @ConditionalOnMissingBean(name={"taskAssigningRuntimeServerExtension"})
    @ConditionalOnProperty(name={"kieserver.taskAssigning.runtime.enabled"})
    public KieServerExtension taskAssigningRuntimeServerExtension() {
        this.runtimeDisabledValue = System.getProperty("org.kie.server.taskAssigning.runtime.ext.disabled");
        System.setProperty("org.kie.server.taskAssigning.runtime.ext.disabled", Boolean.FALSE.toString());
        return new TaskAssigningRuntimeKieServerExtension();
    }

    @Bean
    @ConditionalOnMissingBean(name={"taskAssigningPersistenceUnitPostProcessor"})
    @ConditionalOnProperty(name={"kieserver.taskAssigning.runtime.enabled"})
    public TaskAssigningPersistenceUnitPostProcessor taskAssigningPersistenceUnitPostProcessor() {
        return new TaskAssigningPersistenceUnitPostProcessor();
    }

    @EventListener
    public void handleContextRefreshEvent(ContextClosedEvent evt) {
        if (this.runtimeDisabledValue != null) {
            System.setProperty("org.kie.server.taskAssigning.runtime.ext.disabled", this.runtimeDisabledValue);
        } else {
            System.clearProperty("org.kie.server.taskAssigning.runtime.ext.disabled");
        }
    }
}

