/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot;

import java.util.Collections;
import java.util.List;
import org.appformer.maven.support.DependencyFilter;
import org.drools.core.impl.InternalKieContainer;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.identity.IdentityProvider;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ImmutableContainerStartupStrategy;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.memory.InMemoryKieServerStateRepository;
import org.kie.server.springboot.ImmutableSpringBootKieContainerInstanceImpl;
import org.kie.server.springboot.SpringBootKieServerImpl;

public class ImmutableSpringBootKieServerImpl
extends SpringBootKieServerImpl {
    private List<KieContainerResource> containers;

    public ImmutableSpringBootKieServerImpl(List<KieServerExtension> extensions, IdentityProvider identityProvider) {
        this(extensions, identityProvider, Collections.emptyList());
    }

    public ImmutableSpringBootKieServerImpl(List<KieServerExtension> extensions, IdentityProvider identityProvider, List<KieContainerResource> containers) {
        super(extensions, identityProvider, (KieServerStateRepository)new InMemoryKieServerStateRepository());
        this.containers = containers;
    }

    protected KieModuleMetaData buildKieModuleMetadata(ReleaseId releaseId) {
        return KieModuleMetaData.Factory.newInJarKieModuleMetaData((ReleaseId)releaseId, (DependencyFilter)DependencyFilter.COMPILE_FILTER);
    }

    protected InternalKieContainer createInternalKieContainer(String containerId, org.kie.server.api.model.ReleaseId releaseId, KieModuleMetaData metaData) {
        return (InternalKieContainer)this.ks.newKieClasspathContainer(containerId, metaData.getClassLoader(), (ReleaseId)releaseId);
    }

    protected KieContainerInstanceImpl createContainerInstanceImpl(String containerId, org.kie.server.api.model.ReleaseId releaseId) {
        return new ImmutableSpringBootKieContainerInstanceImpl(containerId, KieContainerStatus.CREATING, null, releaseId, this);
    }

    @Override
    public void init() {
        this.init((StartupStrategy)new ImmutableContainerStartupStrategy(this.containers));
    }
}

