/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;

public class SpringBootKieServerImpl
extends KieServerImpl {
    private IdentityProvider identityProvider;
    private List<KieServerExtension> extensions;

    public SpringBootKieServerImpl(List<KieServerExtension> extensions, IdentityProvider identityProvider, KieServerStateRepository stateRepository) {
        super(stateRepository);
        this.extensions = extensions;
        this.identityProvider = identityProvider;
    }

    public SpringBootKieServerImpl(List<KieServerExtension> extensions, IdentityProvider identityProvider) {
        this.extensions = extensions;
        this.identityProvider = identityProvider;
    }

    protected List<KieServerExtension> sortKnownExtensions() {
        this.getServerRegistry().registerIdentityProvider(this.identityProvider);
        Collections.sort(this.extensions, new Comparator<KieServerExtension>(){

            @Override
            public int compare(KieServerExtension e1, KieServerExtension e2) {
                return e1.getStartOrder().compareTo(e2.getStartOrder());
            }
        });
        return this.extensions;
    }

    public void init() {
        super.init();
    }
}

