/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.spring.AbstractJaxrsClassesScanServer;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.MinimalPomParser;
import org.appformer.maven.support.PomModel;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerContainerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.ImmutableSpringBootKieServerImpl;
import org.kie.server.springboot.SpringBootKieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class KieServerAutoConfiguration
extends AbstractJaxrsClassesScanServer {
    @Value(value="${cxf.path:/}")
    private String cxfPath;
    private static final Logger logger = LoggerFactory.getLogger(KieServerAutoConfiguration.class);
    private KieServerProperties properties;
    private IdentityProvider identityProvider;
    private List<Object> endpoints;
    private boolean jaxrsComponentScanEnabled;
    private KieServerImpl kieServer;

    public KieServerAutoConfiguration(KieServerProperties properties, Optional<IdentityProvider> identityProvider, @Value(value="${cxf.jaxrs.classes-scan:false}") boolean jaxrsComponentScanEnabled) {
        this.properties = properties;
        this.jaxrsComponentScanEnabled = jaxrsComponentScanEnabled;
        if (identityProvider.isPresent()) {
            this.identityProvider = identityProvider.get();
        }
        if (!jaxrsComponentScanEnabled) {
            System.setProperty("cxf.jaxrs.classes-scan-packages", "");
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"kieServerExtension"})
    public KieServerExtension kieServerExtension() {
        return new KieServerContainerExtension();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean(name={"kieServer"})
    public KieServer kieServer(List<KieServerExtension> extensions, List<KieContainerResource> containers) {
        System.setProperty("org.kie.server.sb.cfg.cxf.path", this.cxfPath);
        System.setProperty("org.kie.server.controller", this.properties.getControllers());
        System.setProperty("org.kie.server.location", this.properties.getLocation());
        if (KieServerEnvironment.getServerId() == null) {
            String serverName = this.properties.getServerName();
            String serverId = this.properties.getServerId();
            KieServerEnvironment.setServerId((String)serverId.toString());
            KieServerEnvironment.setServerName((String)serverName);
        }
        logger.info("KieServer (id {} (name {})) started initialization process", (Object)KieServerEnvironment.getServerId(), (Object)KieServerEnvironment.getServerName());
        this.kieServer = this.properties.isClassPathContainer() ? new ImmutableSpringBootKieServerImpl(extensions, this.identityProvider, containers) : new SpringBootKieServerImpl(extensions, this.identityProvider);
        this.kieServer.init();
        KieServerRestImpl kieServerResource = new KieServerRestImpl(this.kieServer);
        this.endpoints = new ArrayList<Object>();
        this.endpoints.add(kieServerResource);
        List activeExtensions = this.kieServer.getServerExtensions();
        for (KieServerExtension extension : activeExtensions) {
            LinkedHashSet resources = new LinkedHashSet(extension.getAppComponents(SupportedTransports.REST));
            this.endpoints.addAll(resources);
        }
        logger.info("KieServer (id {}) started successfully", (Object)KieServerEnvironment.getServerId());
        return this.kieServer;
    }

    @Bean
    @ConditionalOnBean(name={"kieServer"})
    public KieServerRegistry kieServerRegistry(KieServer server) {
        return this.kieServer.getServerRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(name={"embeddedDeployments"})
    @ConditionalOnProperty(name={"kieserver.autoScanDeployments"}, havingValue="false", matchIfMissing=true)
    public List<KieContainerResource> buildDeployments(KieServerProperties kieServerProperties) {
        return kieServerProperties.getDeployments().stream().map(k -> {
            KieContainerResource resource = new KieContainerResource(k.getContainerId(), k.getReleaseId());
            resource.setResolvedReleaseId(k.getReleaseId());
            resource.setContainerAlias(k.getAlias());
            resource.setReleaseId(k.getReleaseId());
            resource.setStatus(KieContainerStatus.STARTED);
            return resource;
        }).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnMissingBean(name={"autoScanEmbeddedDeployments"})
    @ConditionalOnProperty(name={"kieserver.autoScanDeployments"}, havingValue="true")
    public List<KieContainerResource> buildAutoScanDeployments(KieServerProperties kieServerProperties) throws IOException {
        ApplicationHome appHome = new ApplicationHome();
        String folder = "BOOT-INF/classes/KIE-INF/lib/";
        File root = appHome.getSource();
        return this.discoverDeployments("BOOT-INF/classes/KIE-INF/lib/", new FileInputStream(root));
    }

    private List<KieContainerResource> discoverDeployments(String folder, InputStream inputStream) {
        ArrayList<KieContainerResource> files = new ArrayList<KieContainerResource>();
        try (ZipInputStream zipFile = new ZipInputStream(inputStream);){
            ZipEntry entry = null;
            while ((entry = zipFile.getNextEntry()) != null) {
                int available;
                if (!entry.getName().startsWith(folder) || (available = zipFile.available()) <= 0) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = zipFile.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                byte[] content = out.toByteArray();
                out.close();
                Optional<KieContainerResource> resource = this.scanPossibleDeployment(new ByteArrayInputStream(content));
                if (!resource.isPresent()) continue;
                files.add(resource.get());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    private Optional<KieContainerResource> scanPossibleDeployment(InputStream inputStream) {
        boolean isDeployable = false;
        KieContainerResource resource = null;
        ZipEntry entry = null;
        try (ZipInputStream zipFile = new ZipInputStream(inputStream);){
            while ((entry = zipFile.getNextEntry()) != null) {
                if ("META-INF/kmodule.xml".contentEquals(entry.getName())) {
                    isDeployable = true;
                }
                if (!entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.xml")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = zipFile.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                byte[] content = out.toByteArray();
                out.close();
                PomModel model = MinimalPomParser.parse((String)entry.getName(), (InputStream)new ByteArrayInputStream(content));
                AFReleaseId pomReleaseId = model.getReleaseId();
                ReleaseId releaseId = new ReleaseId(pomReleaseId.getGroupId(), pomReleaseId.getArtifactId(), pomReleaseId.getVersion());
                resource = new KieContainerResource(releaseId);
                resource.setContainerId(releaseId.getArtifactId() + "-" + releaseId.getVersion());
                resource.setStatus(KieContainerStatus.STARTED);
                resource.setResolvedReleaseId(releaseId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return isDeployable ? Optional.ofNullable(resource) : Optional.empty();
    }

    protected void setJaxrsResources(JAXRSServerFactoryBean factory) {
        factory.setServiceBeans(this.endpoints);
        if (this.jaxrsComponentScanEnabled) {
            super.setJaxrsResources(factory);
        }
    }

    @Bean
    public Server jaxRsServer(KieServer server) {
        return super.createJaxRsServer();
    }

    public List<Feature> getFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>(super.getFeatures());
        if (this.properties.getSwagger().isEnabled()) {
            try {
                Feature feature = (Feature)Class.forName("org.apache.cxf.jaxrs.swagger.Swagger2Feature").newInstance();
                Method method = ReflectionUtils.findMethod(feature.getClass(), (String)"setRunAsFilter", (Class[])new Class[]{Boolean.TYPE});
                method.invoke((Object)feature, true);
                Method setBasePathMethod = ReflectionUtils.findMethod(feature.getClass(), (String)"setBasePath", (Class[])new Class[]{String.class});
                setBasePathMethod.invoke((Object)feature, this.cxfPath);
                features.add(feature);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                logger.error("Swagger feature was enabled but cannot be created", (Throwable)e);
            }
        }
        return features;
    }
}

