/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.springboot.EmbeddedKieJar;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="kieserver")
public class KieServerProperties
implements InitializingBean {
    private static final String PROPERTY_PREFIX = "org.kie.server.";
    private String location = "";
    private String controllers = "";
    private String serverId = "SpringBoot";
    private String serverName = "KieServer-SpringBoot";
    private boolean classPathContainer;
    private Swagger swagger = new Swagger();
    private List<EmbeddedKieJar> deployments;
    private Map<String, String> addons = new HashMap<String, String>();

    public List<EmbeddedKieJar> getDeployments() {
        if (this.deployments == null) {
            return Collections.emptyList();
        }
        return this.deployments;
    }

    public void setDeployments(List<EmbeddedKieJar> deployments) {
        this.deployments = deployments;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getControllers() {
        return this.controllers;
    }

    public void setControllers(String controllers) {
        this.controllers = controllers;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public void setSwagger(Swagger swagger) {
        this.swagger = swagger;
    }

    public Map<String, String> getAddons() {
        return this.addons;
    }

    public void setAddons(Map<String, String> addons) {
        this.addons = addons;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.addons.isEmpty()) {
            for (Map.Entry<String, String> entry : this.addons.entrySet()) {
                System.setProperty(PROPERTY_PREFIX + entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isClassPathContainer() {
        return this.classPathContainer;
    }

    public void setClassPathContainer(boolean classPathContainer) {
        this.classPathContainer = classPathContainer;
    }

    public static class Swagger {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

