/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.spring.factorybeans.KBaseFactoryBean;
import org.kie.spring.factorybeans.KModuleFactoryBean;
import org.kie.spring.factorybeans.KSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="kiePostProcessor")
public class KModuleBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(KModuleBeanFactoryPostProcessor.class);
    private static final String WEB_INF_CLASSES_URL_SUFFIX = "WEB-INF/classes/";
    private static final String WEB_INF_CLASSES_PATH_SUFFIX = "WEB-INF" + File.separator + "classes";
    protected URL kModuleRootUrl;
    protected ReleaseId releaseId;
    private ApplicationContext context;

    public KModuleBeanFactoryPostProcessor() {
    }

    public KModuleBeanFactoryPostProcessor(URL kModuleRootUrl, ApplicationContext context) {
        this.kModuleRootUrl = kModuleRootUrl;
        this.context = context;
    }

    public KModuleBeanFactoryPostProcessor(URL kModuleRootUrl) {
        this.kModuleRootUrl = kModuleRootUrl;
    }

    public URL getkModuleRootUrl() {
        return this.kModuleRootUrl;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        log.info(":: BeanFactoryPostProcessor::postProcessBeanFactory called ::");
        String kModuleRootPath = this.parseKModuleRootPath(this.kModuleRootUrl);
        if (this.releaseId == null && kModuleRootPath != null) {
            String pomProperties = null;
            if (kModuleRootPath.endsWith(WEB_INF_CLASSES_PATH_SUFFIX)) {
                String configFilePathForWebApps = kModuleRootPath.substring(0, kModuleRootPath.indexOf(WEB_INF_CLASSES_PATH_SUFFIX));
                pomProperties = ClasspathKieProject.getPomProperties((String)configFilePathForWebApps);
            }
            if (pomProperties == null) {
                pomProperties = ClasspathKieProject.getPomProperties((String)kModuleRootPath);
            }
            this.releaseId = pomProperties != null ? ReleaseIdImpl.fromPropertiesString((String)pomProperties) : KieRepositoryImpl.INSTANCE.getDefaultReleaseId();
            log.info("Found project with releaseId: " + this.releaseId);
        }
        if (this.releaseId == null) {
            this.releaseId = KieRepositoryImpl.INSTANCE.getDefaultReleaseId();
        }
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equalsIgnoreCase(KModuleFactoryBean.class.getName())) continue;
            KieModuleModel kieModuleModel = this.fetchKieModuleModel(beanFactory);
            this.addKieModuleToRepo(kieModuleModel);
        }
    }

    private String parseKModuleRootPath(URL kModuleRootUrl) {
        return ClasspathKieProject.fixURLFromKProjectPath((URL)kModuleRootUrl);
    }

    private void addKieModuleToRepo(KieModuleModel kieProject) {
        KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieProject);
        InternalKieModule kJar = this.createKieModule(kieProject);
        if (kJar != null) {
            KieServices ks = KieServices.Factory.get();
            log.info("Adding KieModule from " + this.parseKModuleRootPath(this.kModuleRootUrl) + " to repository.");
            ks.getRepository().addKieModule((KieModule)kJar);
        }
    }

    protected InternalKieModule createKieModule(KieModuleModel kieProject) {
        String rootPath = this.parseKModuleRootPath(this.kModuleRootUrl);
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = rootPath.substring(rootPath.lastIndexOf(58) + 1);
        }
        return ClasspathKieProject.createInternalKieModule(null, null, (KieModuleModel)kieProject, (ReleaseId)this.releaseId, (String)rootPath);
    }

    private KieModuleModel fetchKieModuleModel(ConfigurableListableBeanFactory beanFactory) {
        KieModuleModelImpl kieModuleModel = new KieModuleModelImpl();
        this.addKieBaseModels(beanFactory, kieModuleModel);
        return kieModuleModel;
    }

    private void addKieBaseModels(ConfigurableListableBeanFactory beanFactory, KieModuleModelImpl kieModuleModel) {
        BeanExpressionContext context = new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null);
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            String scope;
            String declarativeAgenda;
            String equalsBehavior;
            String eventMode;
            String includes;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equalsIgnoreCase(KBaseFactoryBean.class.getName())) continue;
            KieBaseModelImpl kBase = new KieBaseModelImpl();
            kBase.setKModule((KieModuleModel)kieModuleModel);
            kBase.setName(this.getPropertyValue(beanDefinition, "kBaseName"));
            kBase.setDefault("true".equals(this.getPropertyValue(beanDefinition, "def")));
            String packages = this.getPropertyValue(beanDefinition, "packages");
            if (!packages.isEmpty()) {
                packages = this.checkAndResolveSpringExpression(beanFactory, context, packages);
                for (String pkg : packages.split(",")) {
                    kBase.addPackage(pkg.trim());
                }
            }
            if (!(includes = this.getPropertyValue(beanDefinition, "includes")).isEmpty()) {
                includes = this.checkAndResolveSpringExpression(beanFactory, context, includes);
                for (String include : includes.split(",")) {
                    kBase.addInclude(include.trim());
                }
            }
            if (!(eventMode = this.getPropertyValue(beanDefinition, "eventProcessingMode")).isEmpty()) {
                eventMode = this.checkAndResolveSpringExpression(beanFactory, context, eventMode);
                kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventMode));
            }
            if (!(equalsBehavior = this.getPropertyValue(beanDefinition, "equalsBehavior")).isEmpty()) {
                equalsBehavior = this.checkAndResolveSpringExpression(beanFactory, context, equalsBehavior);
                kBase.setEqualsBehavior(EqualityBehaviorOption.determineEqualityBehavior((String)equalsBehavior));
            }
            if (!(declarativeAgenda = this.getPropertyValue(beanDefinition, "declarativeAgenda")).isEmpty()) {
                declarativeAgenda = this.checkAndResolveSpringExpression(beanFactory, context, declarativeAgenda);
                kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgenda((String)declarativeAgenda));
            }
            if (!(scope = this.getPropertyValue(beanDefinition, "scope")).isEmpty()) {
                scope = this.checkAndResolveSpringExpression(beanFactory, context, scope);
                kBase.setScope(scope.trim());
            }
            kieModuleModel.getRawKieBaseModels().put(kBase.getName(), kBase);
            beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue("releaseId", (Object)this.releaseId));
            this.addKieSessionModels(beanFactory, kBase);
        }
    }

    protected String checkAndResolveSpringExpression(ConfigurableListableBeanFactory beanFactory, BeanExpressionContext context, String expression) {
        if (expression.startsWith("#{") && expression.endsWith("}")) {
            return (String)beanFactory.getBeanExpressionResolver().evaluate(expression, context);
        }
        return expression;
    }

    private String getPropertyValue(BeanDefinition beanDefinition, String propertyName) {
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue(propertyName);
        return propertyValue != null ? (String)propertyValue.getValue() : "";
    }

    private void addKieSessionModels(ConfigurableListableBeanFactory beanFactory, KieBaseModelImpl kBase) {
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            String scope;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (beanDefinition.getBeanClassName() == null || !beanDefinition.getBeanClassName().equalsIgnoreCase(KSessionFactoryBean.class.getName())) continue;
            String kBaseName = this.getPropertyValue(beanDefinition, "kBaseName");
            if (!kBase.getName().equalsIgnoreCase(kBaseName)) continue;
            String name = this.getPropertyValue(beanDefinition, "name");
            String type = this.getPropertyValue(beanDefinition, "type");
            KieSessionModelImpl kSession = new KieSessionModelImpl(kBase, name);
            kSession.setType(!type.isEmpty() ? KieSessionModel.KieSessionType.valueOf((String)type.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
            Map rawKieSessionModels = kBase.getRawKieSessionModels();
            rawKieSessionModels.put(kSession.getName(), kSession);
            beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue("releaseId", (Object)this.releaseId));
            kSession.setDefault("true".equals(this.getPropertyValue(beanDefinition, "def")));
            String clockType = this.getPropertyValue(beanDefinition, "clockType");
            if (!clockType.isEmpty()) {
                kSession.setClockType(ClockTypeOption.get((String)clockType));
            }
            if ((scope = this.getPropertyValue(beanDefinition, "scope")).isEmpty()) continue;
            kSession.setScope(scope.trim());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        try {
            this.kModuleRootUrl = this.tryGetRootUrlForEapContext(applicationContext.getClassLoader().getResources("/"));
            if (this.kModuleRootUrl == null) {
                this.kModuleRootUrl = applicationContext.getResource("classpath:/").getURL();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to get root URL for the application context " + applicationContext.getDisplayName(), e);
        }
        log.debug("KieModule root URL (based on application context {}): {}", (Object)applicationContext.getDisplayName(), (Object)this.kModuleRootUrl);
    }

    URL tryGetRootUrlForEapContext(Enumeration<URL> rootUrls) {
        boolean containsEapSpecificUrl = false;
        boolean containsWebInfClassesUrl = false;
        URL webInfClassesUrl = null;
        while (rootUrls.hasMoreElements()) {
            URL url = rootUrls.nextElement();
            if (this.isEapSpecificUrl(url)) {
                containsEapSpecificUrl = true;
                continue;
            }
            if (!url.toString().endsWith(WEB_INF_CLASSES_URL_SUFFIX)) continue;
            containsWebInfClassesUrl = true;
            webInfClassesUrl = url;
        }
        if (containsEapSpecificUrl && containsWebInfClassesUrl) {
            return webInfClassesUrl;
        }
        return null;
    }

    boolean isEapSpecificUrl(URL url) {
        return url.toString().endsWith("service-loader-resources/");
    }
}

