/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.namespace;

import java.util.List;
import org.drools.core.util.StringUtils;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class LoggerUtil {
    static int i = 0;

    public static void parseRuntimeLoggers(ParserContext parserContext, BeanDefinitionBuilder factory, Element element) {
        Element consoleLoggerElement;
        ManagedList loggerAdaptors = new ManagedList();
        List fileLoggerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"fileLogger");
        if (fileLoggerElements != null) {
            for (Element fileLoggerElement : fileLoggerElements) {
                String id = LoggerUtil.checkAndSetID(element, fileLoggerElement);
                parserContext.getDelegate().parsePropertySubElement(fileLoggerElement, null, null);
                loggerAdaptors.add((Object)new RuntimeBeanReference(id));
            }
        }
        if ((consoleLoggerElement = DomUtils.getChildElementByTagName((Element)element, (String)"consoleLogger")) != null) {
            String id = LoggerUtil.checkAndSetID(element, consoleLoggerElement);
            parserContext.getDelegate().parsePropertySubElement(consoleLoggerElement, null, null);
            loggerAdaptors.add((Object)new RuntimeBeanReference(id));
        }
        if (loggerAdaptors.size() > 0) {
            factory.addPropertyValue("knowledgeRuntimeLoggers", (Object)loggerAdaptors);
        }
    }

    private static String checkAndSetID(Element parent, Element element) {
        String id = element.getAttribute("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = parent.getAttribute("id") + "_fl" + i;
            element.setAttribute("id", id);
            ++i;
        }
        return id;
    }
}

