/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.KieObjectsResolver;
import org.kie.spring.factorybeans.LoggerAdaptor;
import org.kie.spring.factorybeans.helper.KSessionFactoryBeanHelper;
import org.kie.spring.factorybeans.helper.StatefulKSessionFactoryBeanHelper;
import org.kie.spring.factorybeans.helper.StatelessKSessionFactoryBeanHelper;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.ManagedList;

public class KSessionFactoryBean
implements FactoryBean,
InitializingBean {
    private Object kSession;
    private String id;
    private String type;
    private KieBase kBase;
    private String kBaseName;
    private String name;
    private List<Command<?>> batch;
    private KieSessionConfiguration conf;
    private StatefulKSessionFactoryBeanHelper.JpaConfiguration jpaConfiguration;
    protected KSessionFactoryBeanHelper helper;
    protected ManagedList<LoggerAdaptor> loggerAdaptors = new ManagedList();
    protected List<AgendaEventListener> agendaEventListeners;
    protected List<ProcessEventListener> processEventListeners;
    protected List<RuleRuntimeEventListener> ruleRuntimeEventListeners;
    protected List<Object> groupedListeners = new ArrayList<Object>();
    private ReleaseId releaseId;
    private String def;
    private String scope;

    public KSessionFactoryBean() {
        this.agendaEventListeners = new ArrayList<AgendaEventListener>();
        this.processEventListeners = new ArrayList<ProcessEventListener>();
        this.ruleRuntimeEventListeners = new ArrayList<RuleRuntimeEventListener>();
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public KieSessionConfiguration getConf() {
        return this.conf;
    }

    public void setConf(KieSessionConfiguration conf) {
        this.conf = conf;
    }

    public String getKBaseName() {
        return this.kBaseName;
    }

    public void setKBaseName(String kBaseName) {
        this.kBaseName = kBaseName;
    }

    public void setkBaseName(String kBaseName) {
        this.kBaseName = kBaseName;
    }

    public List<Command<?>> getBatch() {
        return this.batch;
    }

    public void setBatch(List<Command<?>> commands) {
        this.batch = commands;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public KieBase getKBase() {
        return this.kBase;
    }

    public void setKBase(KieBase kBase) {
        this.kBase = kBase;
    }

    public void setkBase(KieBase kBase) {
        this.kBase = kBase;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDef() {
        return this.def;
    }

    public void setDef(String def) {
        this.def = def;
    }

    public Object getObject() throws Exception {
        if ("prototype".equalsIgnoreCase(this.scope)) {
            this.helper.setKieBase(this.kBase);
            Object kSession = this.helper.internalNewObject();
            this.attachLoggers((KieRuntimeEventManager)kSession);
            this.attachListeners((KieRuntimeEventManager)kSession);
            return kSession;
        }
        return this.helper.internalGetObject();
    }

    public Class<? extends KieRuntime> getObjectType() {
        return KieRuntime.class;
    }

    public boolean isSingleton() {
        return "singleton".equalsIgnoreCase(this.scope);
    }

    public void afterPropertiesSet() throws Exception {
        if ("singleton".equalsIgnoreCase(this.scope)) {
            KieObjectsResolver kieObjectsResolver = new KieObjectsResolver();
            this.kSession = kieObjectsResolver.resolveKSession(this.name, this.releaseId);
            if (this.kSession instanceof StatelessKieSession) {
                this.helper = new StatelessKSessionFactoryBeanHelper(this, (StatelessKieSession)this.kSession);
            } else if (this.kSession instanceof KieSession) {
                this.helper = new StatefulKSessionFactoryBeanHelper(this, (KieSession)this.kSession);
            }
            this.helper.internalAfterPropertiesSet();
            this.kSession = this.helper.internalGetObject();
            this.attachLoggers((KieRuntimeEventManager)this.kSession);
            this.attachListeners((KieRuntimeEventManager)this.kSession);
        } else {
            this.helper = "stateless".equalsIgnoreCase(this.type) ? new StatelessKSessionFactoryBeanHelper(this, null) : new StatefulKSessionFactoryBeanHelper(this, null);
        }
    }

    public StatefulKSessionFactoryBeanHelper.JpaConfiguration getJpaConfiguration() {
        return this.jpaConfiguration;
    }

    public void setJpaConfiguration(StatefulKSessionFactoryBeanHelper.JpaConfiguration jpaConfiguration) {
        this.jpaConfiguration = jpaConfiguration;
    }

    public void setEventListenersFromGroup(List<Object> eventListenerList) {
        for (Object eventListener : eventListenerList) {
            if (eventListener instanceof AgendaEventListener) {
                this.agendaEventListeners.add((AgendaEventListener)eventListener);
            }
            if (eventListener instanceof RuleRuntimeEventListener) {
                this.ruleRuntimeEventListeners.add((RuleRuntimeEventListener)eventListener);
            }
            if (!(eventListener instanceof ProcessEventListener)) continue;
            this.processEventListeners.add((ProcessEventListener)eventListener);
        }
        this.groupedListeners.addAll(eventListenerList);
    }

    public List<LoggerAdaptor> getKnowledgeRuntimeLoggers() {
        return this.loggerAdaptors;
    }

    public void setKnowledgeRuntimeLoggers(List<LoggerAdaptor> loggers) {
        this.loggerAdaptors.addAll(loggers);
    }

    public void attachLoggers(KieRuntimeEventManager ksession) {
        if (this.loggerAdaptors != null && !this.loggerAdaptors.isEmpty()) {
            KieServices ks = KieServices.Factory.get();
            KieLoggers loggers = ks.getLoggers();
            for (LoggerAdaptor adaptor : this.loggerAdaptors) {
                switch (adaptor.getLoggerType()) {
                    case LOGGER_TYPE_FILE: {
                        KieRuntimeLogger runtimeLogger = loggers.newFileLogger(ksession, adaptor.getFile());
                        adaptor.setRuntimeLogger(runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_THREADED_FILE: {
                        KieRuntimeLogger runtimeLogger = loggers.newThreadedFileLogger(ksession, adaptor.getFile(), adaptor.getInterval());
                        adaptor.setRuntimeLogger(runtimeLogger);
                        break;
                    }
                    case LOGGER_TYPE_CONSOLE: {
                        KieRuntimeLogger runtimeLogger = loggers.newConsoleLogger(ksession);
                        adaptor.setRuntimeLogger(runtimeLogger);
                    }
                }
            }
        }
    }

    public void setEventListeners(Map<String, List> eventListenerMap) {
        for (Map.Entry<String, List> entry : eventListenerMap.entrySet()) {
            String key = entry.getKey();
            List eventListenerList = entry.getValue();
            if ("agenda-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (eventListener instanceof AgendaEventListener) {
                        this.agendaEventListeners.add((AgendaEventListener)eventListener);
                        continue;
                    }
                    throw new IllegalArgumentException("The agendaEventListener (" + eventListener.getClass() + ") is not an instance of " + AgendaEventListener.class);
                }
                continue;
            }
            if ("working-memory-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (eventListener instanceof RuleRuntimeEventListener) {
                        this.ruleRuntimeEventListeners.add((RuleRuntimeEventListener)eventListener);
                        continue;
                    }
                    throw new IllegalArgumentException("The ruleRuntimeEventListener (" + eventListener.getClass() + ") is not an instance of " + RuleRuntimeEventListener.class);
                }
                continue;
            }
            if (!"process-event-listener".equalsIgnoreCase(key)) continue;
            for (Object eventListener : eventListenerList) {
                if (eventListener instanceof ProcessEventListener) {
                    this.processEventListeners.add((ProcessEventListener)eventListener);
                    continue;
                }
                throw new IllegalArgumentException("The processEventListener (" + eventListener.getClass() + ") is not an instance of " + ProcessEventListener.class);
            }
        }
    }

    public List<AgendaEventListener> getAgendaEventListeners() {
        return this.agendaEventListeners;
    }

    public void setAgendaEventListeners(List<AgendaEventListener> agendaEventListeners) {
        this.agendaEventListeners = agendaEventListeners;
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventListeners;
    }

    public void setProcessEventListeners(List<ProcessEventListener> processEventListeners) {
        this.processEventListeners = processEventListeners;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.ruleRuntimeEventListeners;
    }

    public void setRuleRuntimeEventListeners(List<RuleRuntimeEventListener> ruleRuntimeEventListeners) {
        this.ruleRuntimeEventListeners = ruleRuntimeEventListeners;
    }

    public void attachListeners(KieRuntimeEventManager kieRuntimeEventManager) {
        for (AgendaEventListener agendaEventListener : this.getAgendaEventListeners()) {
            kieRuntimeEventManager.addEventListener(agendaEventListener);
        }
        for (ProcessEventListener processEventListener : this.getProcessEventListeners()) {
            kieRuntimeEventManager.addEventListener(processEventListener);
        }
        for (RuleRuntimeEventListener ruleRuntimeEventListener : this.getRuleRuntimeEventListeners()) {
            kieRuntimeEventManager.addEventListener(ruleRuntimeEventListener);
        }
    }
}

